#include "EngduinoLEDs.h"

// This is a sophisticated example of interfacing to the Engduino.
//
// It makes use of a pulse sensor that can be obtained from www.pulsesensor.com
// This returns an analogue signal, which is picked up on the IO_1 expansion pin
// and the code does some processing to determine which part of a heartbeat the
// signal belongs to. It outputs this in the form of flashing LEDs and, in more
// detail over the serial link. This can be shown on a GUI, an example of which
// is included as 'Processing' code. To run that code you will need to download
// Processing from http://processing.org/ Clearly it would also be possible to
// write a similar interface in Python, Java, or the web technology of your choice
//

/*
>> Pulse Sensor Amped 1.1 <<
This code is for Pulse Sensor Amped by Joel Murphy and Yury Gitman
    www.pulsesensor.com 
    >>> Pulse Sensor purple wire goes to Analog Pin 0 <<<
Pulse Sensor sample aquisition and processing happens in the background via Timer 2 interrupt. 2mS sample rate.
PWM on pins 3 and 11 will not work when using this code, because we are using Timer 2!
The following variables are automatically updated:
Signal :    int that holds the analog signal data straight from the sensor. updated every 2mS.
IBI  :      int that holds the time interval between beats. 2mS resolution.
BPM  :      int that holds the heart rate value, derived every beat, from averaging previous 10 IBI values.
QS  :       boolean that is made true whenever Pulse is found and BPM is updated. User must reset.
Pulse :     boolean that is true when a heartbeat is sensed then false in time with pin13 LED going out.

This code is designed with output serial data to Processing sketch "PulseSensorAmped_Processing-xx"
The Processing sketch is a simple data visualizer. 
All the work to find the heartbeat and determine the heartrate happens in the code below.
Pin 13 LED will blink with heartbeat.
If you want to use pin 13 for something else, adjust the interrupt handler
It will also fade the Engduino LEDs with every beat.
Check here for detailed code walkthrough - but note that the code here has been very slighly modified for Engduino:
http://pulsesensor.myshopify.com/pages/pulse-sensor-amped-arduino-v1dot1

Code Version 02 by Joel Murphy & Yury Gitman  Fall 2012
This update changes the HRV variable name to IBI, which stands for Inter-Beat Interval, for clarity.
Switched the interrupt to Timer2.  500Hz sample rate, 2mS resolution IBI value.
Fade LED pin moved to pin 5 (use of Timer2 disables PWM on pins 3 & 11).
Tidied up inefficiencies since the last version. 
*/



void pulsesensor(){
  if (Signal > 0)
    sendDataToProcessing('S', Signal);     // send Processing the raw Pulse Sensor data
  if (QS == true){                       // Quantified Self flag is true when arduino finds a heartbeat
        fadeRate = 255;                  // Set 'fadeRate' Variable to 255 to fade LED with pulse
        sendDataToProcessing('B',BPM);   // send heart rate with a 'B' prefix
        sendDataToProcessing('Q',IBI);   // send time between beats with a 'Q' prefix
        QS = false;                      // reset the Quantified Self flag for next time   
        LEDpos=0; 
        
     }
  
  //ledFadeToBeat();
  displayLight();
  delay(20);                             //  take a break
  
}


void ledFadeToBeat(){
    fadeRate -= 15;                         //  set LED fade value
    fadeRate = constrain(fadeRate,0,255);   //  keep LED fade value from going into negative numbers!
    EngduinoLEDs.setAll(RED, fadeRate);
  }
  
void displayLight(){
  if (LEDpos < 16) {
    EngduinoLEDs.setAll(OFF);
    EngduinoLEDs.setLED(LEDpos, LEDpos, 0, 5);
    LEDpos++;
  } 
  
}


void sendDataToProcessing(char symbol, int data ){
    Serial.print(symbol);                // symbol prefix tells Processing what type of data is coming
    Serial.println(data);                // the data to send culminating in a carriage return
  }







