/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Graphics;
import com.sun.prism.Presentable;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.j2d.J2DPrismGraphics;
import com.sun.prism.j2d.J2DRTTexture;
import com.sun.prism.j2d.J2DResourceFactory;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class J2DPresentable
implements Presentable {
    J2DResourceFactory factory;
    boolean needsResize;
    BufferedImage buffer;
    IntBuffer ib;
    J2DRTTexture readbackBuffer;

    public static J2DPresentable create(View view, J2DResourceFactory j2DResourceFactory) {
        return new Glass(view, j2DResourceFactory);
    }

    public static J2DPresentable create(BufferedImage bufferedImage, J2DResourceFactory j2DResourceFactory) {
        return new Bimg(bufferedImage, j2DResourceFactory);
    }

    protected J2DPresentable(BufferedImage bufferedImage, J2DResourceFactory j2DResourceFactory) {
        this.buffer = bufferedImage;
        this.factory = j2DResourceFactory;
    }

    public void setNeedsResize() {
        this.needsResize = true;
    }

    ResourceFactory getResourceFactory() {
        return this.factory;
    }

    public abstract BufferedImage createBuffer(int var1, int var2);

    @Override
    public Graphics createGraphics() {
        int n = this.getContentWidth();
        int n2 = this.getContentHeight();
        if (this.buffer == null || this.buffer.getWidth() != n || this.buffer.getHeight() != n2) {
            this.buffer = null;
            this.readbackBuffer = null;
            this.buffer = this.createBuffer(n, n2);
            WritableRaster writableRaster = this.buffer.getRaster();
            DataBuffer dataBuffer = writableRaster.getDataBuffer();
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            this.ib = IntBuffer.wrap(nArray, dataBuffer.getOffset(), dataBuffer.getSize());
        }
        this.needsResize = false;
        Graphics2D graphics2D = (Graphics2D)this.buffer.getGraphics();
        return new J2DPrismGraphics(this, graphics2D);
    }

    public J2DRTTexture getReadbackBuffer() {
        if (this.readbackBuffer == null) {
            this.readbackBuffer = (J2DRTTexture)this.factory.createRTTexture(this.getContentWidth(), this.getContentHeight());
        }
        return this.readbackBuffer;
    }

    public BufferedImage getBackBuffer() {
        return this.buffer;
    }

    @Override
    public Screen getAssociatedScreen() {
        return this.factory.getScreen();
    }

    @Override
    public long getNativeDestHandle() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getContentX() {
        return 0;
    }

    @Override
    public int getContentY() {
        return 0;
    }

    @Override
    public float getPixelScaleFactor() {
        return 1.0f;
    }

    @Override
    public int getPhysicalWidth() {
        return this.buffer == null ? this.getContentWidth() : this.buffer.getWidth();
    }

    @Override
    public int getPhysicalHeight() {
        return this.buffer == null ? this.getContentHeight() : this.buffer.getHeight();
    }

    @Override
    public boolean recreateOnResize() {
        return false;
    }

    private static class Bimg
    extends J2DPresentable {
        private boolean opaque;

        public Bimg(BufferedImage bufferedImage, J2DResourceFactory j2DResourceFactory) {
            super(bufferedImage, j2DResourceFactory);
        }

        @Override
        public BufferedImage createBuffer(int n, int n2) {
            throw new UnsupportedOperationException("cannot create new buffers for image");
        }

        @Override
        public boolean prepare(Rectangle rectangle) {
            throw new UnsupportedOperationException("cannot prepare/present on image");
        }

        @Override
        public boolean present() {
            throw new UnsupportedOperationException("cannot prepare/present on image");
        }

        @Override
        public int getContentWidth() {
            return this.buffer.getWidth();
        }

        @Override
        public int getContentHeight() {
            return this.buffer.getHeight();
        }

        @Override
        public void setOpaque(boolean bl) {
            this.opaque = bl;
        }

        @Override
        public boolean isOpaque() {
            return this.opaque;
        }
    }

    private static class Glass
    extends J2DPresentable {
        View glassview;
        Pixels pixels;
        private boolean opaque;
        private final Application app = Application.GetApplication();

        public Glass(View view, J2DResourceFactory j2DResourceFactory) {
            super(null, j2DResourceFactory);
            this.glassview = view;
            this.setNeedsResize();
        }

        @Override
        public BufferedImage createBuffer(int n, int n2) {
            this.pixels = null;
            int n3 = Pixels.getNativeFormat();
            if (PrismSettings.verbose) {
                System.out.println("Glass native format: " + n3);
            }
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            switch (n3) {
                case 1: {
                    if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                        return new BufferedImage(n, n2, 3);
                    }
                    throw new UnsupportedOperationException("BYTE_BGRA_PRE pixel format on BIG_ENDIAN");
                }
                case 2: {
                    if (byteOrder == ByteOrder.BIG_ENDIAN) {
                        return new BufferedImage(n, n2, 2);
                    }
                    throw new UnsupportedOperationException("BYTE_ARGB pixel format on LITTLE_ENDIAN");
                }
            }
            throw new UnsupportedOperationException("unrecognized pixel format: " + n3);
        }

        @Override
        public boolean prepare(Rectangle rectangle) {
            if (!this.glassview.isClosed()) {
                if (this.pixels == null) {
                    this.pixels = this.app.createPixels(this.getPhysicalWidth(), this.getPhysicalHeight(), this.ib);
                }
                return this.pixels != null;
            }
            return false;
        }

        @Override
        public boolean present() {
            final Pixels pixels = this.pixels;
            Application.postOnEventQueue(new Runnable(){

                @Override
                public void run() {
                    if (!Glass.this.glassview.isClosed()) {
                        Glass.this.glassview.uploadPixels(pixels);
                    }
                }
            });
            return true;
        }

        @Override
        public int getContentWidth() {
            return this.glassview.getWidth();
        }

        @Override
        public int getContentHeight() {
            return this.glassview.getHeight();
        }

        @Override
        public void setOpaque(boolean bl) {
            this.opaque = bl;
        }

        @Override
        public boolean isOpaque() {
            return this.opaque;
        }
    }
}

