/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.TextAttribute;
import java.util.Hashtable;
import javax.swing.JComponent;

public class SyntaxStyle {
    private Color color;
    private boolean italic;
    private boolean bold;
    private boolean underlined;
    private Font lastFont;
    private Font lastStyledFont;
    private FontMetrics fontMetrics;

    public SyntaxStyle(Color color, boolean italic, boolean bold, boolean underlined) {
        this.color = color;
        this.italic = italic;
        this.bold = bold;
        this.underlined = underlined;
    }

    public Color getColor() {
        return this.color;
    }

    public boolean isPlain() {
        return !this.bold && !this.italic && !this.underlined;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Font getStyledFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.lastFont)) {
            return this.lastStyledFont;
        }
        this.lastFont = font;
        this.lastStyledFont = new Font(font.getFamily(), (this.bold ? 1 : 0) | (this.italic ? 2 : 0), font.getSize());
        if (this.underlined) {
            Hashtable<TextAttribute, Integer> attr = new Hashtable<TextAttribute, Integer>();
            attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.lastStyledFont = this.lastStyledFont.deriveFont(attr);
        }
        return this.lastStyledFont;
    }

    public FontMetrics getFontMetrics(Font font, JComponent comp) {
        if (font == null) {
            throw new NullPointerException("font param must not be null");
        }
        if (font.equals(this.lastFont) && this.fontMetrics != null) {
            return this.fontMetrics;
        }
        this.lastFont = font;
        this.lastStyledFont = new Font(font.getFamily(), (this.bold ? 1 : 0) | (this.italic ? 2 : 0), font.getSize());
        if (this.underlined) {
            Hashtable<TextAttribute, Integer> attr = new Hashtable<TextAttribute, Integer>();
            attr.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.lastStyledFont = this.lastStyledFont.deriveFont(attr);
        }
        this.fontMetrics = comp.getFontMetrics(this.lastStyledFont);
        return this.fontMetrics;
    }

    public void setGraphicsFlags(Graphics gfx, Font font) {
        Font _font = this.getStyledFont(font);
        gfx.setFont(_font);
        gfx.setColor(this.color);
    }

    public String toString() {
        return this.getClass().getName() + "[color=" + this.color + (this.italic ? ",italic" : "") + (this.bold ? ",bold" : "") + (this.underlined ? ",underlined" : "") + "]";
    }
}

