/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.helpers.FileUtils;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesHelper;
import processing.app.helpers.PreferencesMap;
import processing.app.legacy.PApplet;

public class Preferences {
    static final String PREFS_FILE = "preferences.txt";
    Language[] languages = new Language[]{new Language(I18n._((String)"System Default"), "", ""), new Language(I18n._((String)"Albanian"), "shqip", "sq"), new Language(I18n._((String)"Arabic"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", "ar"), new Language(I18n._((String)"Aragonese"), "Aragon\u00e9s", "an"), new Language(I18n._((String)"Belarusian"), "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f \u043c\u043e\u0432\u0430", "be"), new Language(I18n._((String)"Bulgarian"), "\u0431\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438", "bg"), new Language(I18n._((String)"Catalan"), "Catal\u00e0", "ca"), new Language(I18n._((String)"Chinese Simplified"), "\u7b80\u4f53\u4e2d\u6587", "zh_CN"), new Language(I18n._((String)"Chinese Traditional"), "\u7e41\u9ad4\u4e2d\u6587", "zh_TW"), new Language(I18n._((String)"Croatian"), "Hrvatski", "hr_HR"), new Language(I18n._((String)"Czech"), "\u010desk\u00fd", "cs_CZ"), new Language(I18n._((String)"Danish"), "Dansk", "da_DK"), new Language(I18n._((String)"Dutch"), "Nederlands", "nl"), new Language(I18n._((String)"English"), "English", "en"), new Language(I18n._((String)"English (United Kingdom)"), "English (United Kingdom)", "en_GB"), new Language(I18n._((String)"Estonian"), "Eesti", "et"), new Language(I18n._((String)"Estonian (Estonia)"), "Eesti keel", "et_EE"), new Language(I18n._((String)"Filipino"), "Pilipino", "fil"), new Language(I18n._((String)"Finnish"), "Suomi", "fi"), new Language(I18n._((String)"French"), "Fran\u00e7ais", "fr"), new Language(I18n._((String)"Canadian French"), "Canadienne-fran\u00e7ais", "fr_CA"), new Language(I18n._((String)"Galician"), "Galego", "gl"), new Language(I18n._((String)"Georgian"), "\u10e1\u10d0\u10e5\u10d0\u10e0\u10d7\u10d5\u10d4\u10da\u10dd\u10e1", "ka_GE"), new Language(I18n._((String)"German"), "Deutsch", "de_DE"), new Language(I18n._((String)"Greek"), "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "el_GR"), new Language(I18n._((String)"Hebrew"), "\u05e2\u05d1\u05e8\u05d9\u05ea", "he"), new Language(I18n._((String)"Hindi"), "\u0939\u093f\u0902\u0926\u0940", "hi"), new Language(I18n._((String)"Hungarian"), "Magyar", "hu"), new Language(I18n._((String)"Indonesian"), "Bahasa Indonesia", "id"), new Language(I18n._((String)"Italian"), "Italiano", "it_IT"), new Language(I18n._((String)"Japanese"), "\u65e5\u672c\u8a9e", "ja_JP"), new Language(I18n._((String)"Korean"), "\ud55c\uad6d\uc5b4", "ko_KR"), new Language(I18n._((String)"Latvian"), "Latvie\u0161u", "lv_LV"), new Language(I18n._((String)"Lithuaninan"), "Lietuvi\u0173 Kalba", "lt_LT"), new Language(I18n._((String)"Norwegian Bokm\u00e5l"), "Norsk bokm\u00e5l", "nb_NO"), new Language(I18n._((String)"Persian"), "\u0641\u0627\u0631\u0633\u06cc", "fa"), new Language(I18n._((String)"Polish"), "J\u0119zyk Polski", "pl"), new Language(I18n._((String)"Portuguese (Brazil)"), "Portugu\u00eas (Brazil)", "pt_BR"), new Language(I18n._((String)"Portuguese (Portugal)"), "Portugu\u00eas (Portugal)", "pt_PT"), new Language(I18n._((String)"Romanian"), "Rom\u00e2n\u0103", "ro"), new Language(I18n._((String)"Russian"), "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "ru"), new Language(I18n._((String)"Slovenian"), "Sloven\u0161\u010dina", "sl_SI"), new Language(I18n._((String)"Spanish"), "Espa\u00f1ol", "es"), new Language(I18n._((String)"Swedish"), "Svenska", "sv"), new Language(I18n._((String)"Tamil"), "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", "ta"), new Language(I18n._((String)"Turkish"), "T\u00fcrk", "tr"), new Language(I18n._((String)"Ukrainian"), "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439", "uk"), new Language(I18n._((String)"Vietnamese"), "Ti\u1ebfng Vi\u1ec7t", "vi")};
    Language[] missingLanguages = new Language[]{new Language(I18n._((String)"Armenian"), "\u0540\u0561\u0575\u0565\u0580\u0565\u0576", "hy"), new Language(I18n._((String)"Asturian"), "Asturianu", "ast"), new Language(I18n._((String)"Basque"), "Euskara", "eu"), new Language(I18n._((String)"Bosnian"), "Bosanski", "bs"), new Language(I18n._((String)"Burmese (Myanmar)"), "\u1017\u1019\u102c\u1005\u1000\u102c\u1038", "my_MM"), new Language(I18n._((String)"Chinese (China)"), "", "zh_CN"), new Language(I18n._((String)"Chinese (Hong Kong)"), "", "zh_HK"), new Language(I18n._((String)"Chinese (Taiwan)"), "", "zh_TW"), new Language(I18n._((String)"Chinese (Taiwan) (Big5)"), "", "zh_TW.Big5"), new Language(I18n._((String)"Dutch (Netherlands)"), "Nederlands", "nl_NL"), new Language(I18n._((String)"Nepali"), "\u0928\u0947\u092a\u093e\u0932\u0940", "ne"), new Language(I18n._((String)"N'Ko"), "\u07d2\u07de\u07cf", "nqo"), new Language(I18n._((String)"Marathi"), "\u092e\u0930\u093e\u0920\u0940", "mr"), new Language(I18n._((String)"Portugese"), "Portugu\u00eas", "pt"), new Language(I18n._((String)"Persian (Iran)"), "\u0641\u0627\u0631\u0633\u06cc (Iran)", "fa_IR")};
    public static int BUTTON_WIDTH = 80;
    public static int BUTTON_HEIGHT = 24;
    static final int GRID_SIZE = 33;
    static final int GUI_BIG = 13;
    static final int GUI_BETWEEN = 10;
    static final int GUI_SMALL = 6;
    JFrame dialog = new JFrame(I18n._((String)"Preferences"));
    int wide;
    int high;
    JTextField sketchbookLocationField;
    JCheckBox exportSeparateBox;
    JCheckBox verboseCompilationBox;
    JCheckBox verboseUploadBox;
    JCheckBox displayLineNumbersBox;
    JCheckBox verifyUploadBox;
    JCheckBox externalEditorBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JTextField fontSizeField;
    JCheckBox updateExtensionBox;
    JCheckBox autoAssociateBox;
    JComboBox comboLanguage;
    JCheckBox saveVerifyUploadBox;
    Editor editor;

    protected static void init(File file) {
        PreferencesData.init((File)file);
        PreferencesHelper.putColor((PreferencesMap)PreferencesData.prefs, (String)"run.window.bgcolor", (Color)SystemColor.control);
    }

    public Preferences() {
        this.dialog.setResizable(false);
        Container pain = this.dialog.getContentPane();
        pain.setLayout(null);
        int top = 13;
        int left = 13;
        int right = 0;
        JLabel label = new JLabel(I18n._((String)"Sketchbook location:"));
        pain.add(label);
        Dimension d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        top += d.height;
        this.sketchbookLocationField = new JTextField(40);
        pain.add(this.sketchbookLocationField);
        d = this.sketchbookLocationField.getPreferredSize();
        JButton button = new JButton(I18n.PROMPT_BROWSE);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File dflt = new File(Preferences.this.sketchbookLocationField.getText());
                File file = Base.selectFolder(I18n._((String)"Select new sketchbook location"), dflt, Preferences.this.dialog);
                if (file != null) {
                    String path = file.getAbsolutePath();
                    if (Base.getPortableFolder() != null && (path = FileUtils.relativePath((String)Base.getPortableFolder().toString(), (String)path)) == null) {
                        path = Base.getPortableSketchbookFolder();
                    }
                    Preferences.this.sketchbookLocationField.setText(path);
                }
            }
        });
        pain.add(button);
        Dimension d2 = button.getPreferredSize();
        int vmax = Math.max(d.height, d2.height);
        this.sketchbookLocationField.setBounds(left, top + (vmax - d.height) / 2, d.width, d.height);
        int h = left + d.width + 6;
        button.setBounds(h, top + (vmax - d2.height) / 2, d2.width, d2.height);
        right = Math.max(right, h + d2.width + 13);
        top += vmax + 10;
        Box box = Box.createHorizontalBox();
        label = new JLabel(I18n._((String)"Editor language: "));
        box.add(label);
        this.comboLanguage = new JComboBox<Language>(this.languages);
        String currentLanguage = PreferencesData.get((String)"editor.languages.current");
        for (Language language : this.languages) {
            if (!language.isoCode.equals(currentLanguage)) continue;
            this.comboLanguage.setSelectedItem(language);
        }
        box.add(this.comboLanguage);
        label = new JLabel(I18n._((String)"  (requires restart of Arduino)"));
        box.add(label);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        ((Component)box).setForeground(Color.gray);
        box.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        box = Box.createHorizontalBox();
        label = new JLabel(I18n._((String)"Editor font size: "));
        box.add(label);
        this.fontSizeField = new JTextField(4);
        box.add(this.fontSizeField);
        label = new JLabel(I18n._((String)"  (requires restart of Arduino)"));
        box.add(label);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        box.setBounds(left, top, d.width, d.height);
        Font editorFont = Preferences.getFont("editor.font");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        top += d.height + 10;
        box = Box.createHorizontalBox();
        label = new JLabel(I18n._((String)"Show verbose output during: "));
        box.add(label);
        this.verboseCompilationBox = new JCheckBox(I18n._((String)"compilation "));
        box.add(this.verboseCompilationBox);
        this.verboseUploadBox = new JCheckBox(I18n._((String)"upload"));
        box.add(this.verboseUploadBox);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        box.setBounds(left, top, d.width, d.height);
        this.displayLineNumbersBox = new JCheckBox(I18n._((String)"Display line numbers"));
        pain.add(this.displayLineNumbersBox);
        d = this.displayLineNumbersBox.getPreferredSize();
        this.displayLineNumbersBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.verifyUploadBox = new JCheckBox(I18n._((String)"Verify code after upload"));
        pain.add(this.verifyUploadBox);
        d = this.verifyUploadBox.getPreferredSize();
        this.verifyUploadBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.externalEditorBox = new JCheckBox(I18n._((String)"Use external editor"));
        pain.add(this.externalEditorBox);
        d = this.externalEditorBox.getPreferredSize();
        this.externalEditorBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.checkUpdatesBox = new JCheckBox(I18n._((String)"Check for updates on startup"));
        pain.add(this.checkUpdatesBox);
        d = this.checkUpdatesBox.getPreferredSize();
        this.checkUpdatesBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.updateExtensionBox = new JCheckBox(I18n._((String)"Update sketch files to new extension on save (.pde -> .ino)"));
        pain.add(this.updateExtensionBox);
        d = this.updateExtensionBox.getPreferredSize();
        this.updateExtensionBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        if (OSUtils.isWindows()) {
            this.autoAssociateBox = new JCheckBox(I18n._((String)"Automatically associate .ino files with Arduino"));
            pain.add(this.autoAssociateBox);
            d = this.autoAssociateBox.getPreferredSize();
            this.autoAssociateBox.setBounds(left, top, d.width + 10, d.height);
            right = Math.max(right, left + d.width);
            top += d.height + 10;
            if (Base.getPortableFolder() != null) {
                this.autoAssociateBox.setEnabled(false);
            }
        }
        this.saveVerifyUploadBox = new JCheckBox(I18n._((String)"Save when verifying or uploading"));
        pain.add(this.saveVerifyUploadBox);
        d = this.saveVerifyUploadBox.getPreferredSize();
        this.saveVerifyUploadBox.setBounds(left, top, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        label = new JLabel(I18n._((String)"More preferences can be edited directly in the file"));
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        final JLabel clickable = label = new JLabel(PreferencesData.preferencesFile.getAbsolutePath());
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Base.openFolder(PreferencesData.preferencesFile.getParentFile());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                clickable.setForeground(new Color(0, 0, 140));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                clickable.setForeground(Color.BLACK);
            }
        });
        pain.add(label);
        d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        label = new JLabel(I18n._((String)"(edit only when Arduino is not running)"));
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        button = new JButton(I18n.PROMPT_OK);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.applyFrame();
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        d2 = button.getPreferredSize();
        BUTTON_HEIGHT = d2.height;
        h = right - (BUTTON_WIDTH + 6 + BUTTON_WIDTH);
        button.setBounds(h, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        button = new JButton(I18n.PROMPT_CANCEL);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        button.setBounds(h += BUTTON_WIDTH + 6, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        this.wide = right + 13;
        this.high = (top += BUTTON_HEIGHT + 10) + 6;
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        ActionListener disposer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        };
        Base.registerWindowCloseKeys(this.dialog.getRootPane(), disposer);
        Base.setIcon(this.dialog);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((screen.width - this.wide) / 2, (screen.height - this.high) / 2);
        this.dialog.pack();
        Insets insets = this.dialog.getInsets();
        this.dialog.setSize(this.wide + insets.left + insets.right, this.high + insets.top + insets.bottom);
        pain.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Editor.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    Preferences.this.disposeFrame();
                }
            }
        });
    }

    protected void disposeFrame() {
        this.dialog.dispose();
    }

    protected void applyFrame() {
        PreferencesData.setBoolean((String)"build.verbose", (boolean)this.verboseCompilationBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verbose", (boolean)this.verboseUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.linenumbers", (boolean)this.displayLineNumbersBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verify", (boolean)this.verifyUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        String oldPath = PreferencesData.get((String)"sketchbook.path");
        String newPath = this.sketchbookLocationField.getText();
        if (newPath.isEmpty()) {
            newPath = Base.getPortableFolder() == null ? this.editor.base.getDefaultSketchbookFolderOrPromptForIt().toString() : Base.getPortableSketchbookFolder();
        }
        if (!newPath.equals(oldPath)) {
            this.editor.base.rebuildSketchbookMenus();
            PreferencesData.set((String)"sketchbook.path", (String)newPath);
        }
        PreferencesData.setBoolean((String)"editor.external", (boolean)this.externalEditorBox.isSelected());
        PreferencesData.setBoolean((String)"update.check", (boolean)this.checkUpdatesBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String[] pieces = PApplet.split((String)PreferencesData.get((String)"editor.font"), (char)',');
            pieces[2] = String.valueOf(newSize);
            PreferencesData.set((String)"editor.font", (String)PApplet.join((String[])pieces, (char)','));
        }
        catch (Exception e) {
            System.err.println(I18n.format((String)I18n._((String)"ignoring invalid font size {0}"), (Object[])new Object[]{newSizeText}));
        }
        if (this.autoAssociateBox != null) {
            PreferencesData.setBoolean((String)"platform.auto_file_type_associations", (boolean)this.autoAssociateBox.isSelected());
        }
        PreferencesData.setBoolean((String)"editor.update_extension", (boolean)this.updateExtensionBox.isSelected());
        Language newLanguage = (Language)this.comboLanguage.getSelectedItem();
        PreferencesData.set((String)"editor.languages.current", (String)newLanguage.isoCode);
        this.editor.applyPreferences();
    }

    protected void showFrame(Editor editor) {
        this.editor = editor;
        this.verboseCompilationBox.setSelected(PreferencesData.getBoolean((String)"build.verbose"));
        this.verboseUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verbose"));
        this.displayLineNumbersBox.setSelected(PreferencesData.getBoolean((String)"editor.linenumbers"));
        this.verifyUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verify"));
        this.sketchbookLocationField.setText(PreferencesData.get((String)"sketchbook.path"));
        this.externalEditorBox.setSelected(PreferencesData.getBoolean((String)"editor.external"));
        this.checkUpdatesBox.setSelected(PreferencesData.getBoolean((String)"update.check"));
        this.saveVerifyUploadBox.setSelected(PreferencesData.getBoolean((String)"editor.save_on_verify"));
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(PreferencesData.getBoolean((String)"platform.auto_file_type_associations"));
        }
        this.updateExtensionBox.setSelected(PreferencesData.get((String)"editor.update_extension") == null || PreferencesData.getBoolean((String)"editor.update_extension"));
        this.dialog.setVisible(true);
    }

    protected static void save() {
        PreferencesData.save();
    }

    public static String get(String attribute) {
        return PreferencesData.get((String)attribute);
    }

    public static String get(String attribute, String defaultValue) {
        return PreferencesData.get((String)attribute, (String)defaultValue);
    }

    public static boolean has(String key) {
        return PreferencesData.has((String)key);
    }

    public static void remove(String key) {
        PreferencesData.remove((String)key);
    }

    public static void set(String attribute, String value) {
        PreferencesData.set((String)attribute, (String)value);
    }

    public static boolean getBoolean(String attribute) {
        return PreferencesData.getBoolean((String)attribute);
    }

    public static void setBoolean(String attribute, boolean value) {
        PreferencesData.setBoolean((String)attribute, (boolean)value);
    }

    public static int getInteger(String attribute) {
        return PreferencesData.getInteger((String)attribute);
    }

    public static void setInteger(String key, int value) {
        PreferencesData.setInteger((String)key, (int)value);
    }

    public static Font getFont(String attr) {
        Font font = PreferencesHelper.getFont((PreferencesMap)PreferencesData.prefs, (String)attr);
        if (font == null) {
            String value = (String)PreferencesData.defaults.get((Object)attr);
            PreferencesData.prefs.put((Object)attr, (Object)value);
            font = PreferencesHelper.getFont((PreferencesMap)PreferencesData.prefs, (String)attr);
        }
        return font;
    }

    public static PreferencesMap getMap() {
        return PreferencesData.getMap();
    }

    public static void setDoSave(boolean value) {
        PreferencesData.setDoSave((boolean)value);
    }

    class Language {
        String name;
        String originalName;
        String isoCode;

        Language(String _name, String _originalName, String _isoCode) {
            this.name = _name;
            this.originalName = _originalName;
            this.isoCode = _isoCode;
        }

        public String toString() {
            if (this.originalName.length() == 0) {
                return this.name;
            }
            return this.originalName + " (" + this.name + ")";
        }
    }
}

