/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.BoardPort;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import processing.app.AbstractMonitor;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.legacy.PApplet;

public class SerialMonitor
extends AbstractMonitor {
    private final String port;
    private Serial serial;
    private int serialRate;

    public SerialMonitor(BoardPort port) {
        super(port.getLabel());
        this.port = port.getAddress();
        this.serialRate = Preferences.getInteger("serial.debug_rate");
        this.serialRates.setSelectedItem(this.serialRate + " " + I18n._((String)"baud"));
        this.onSerialRateChange(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String wholeString = (String)SerialMonitor.this.serialRates.getSelectedItem();
                String rateString = wholeString.substring(0, wholeString.indexOf(32));
                SerialMonitor.this.serialRate = Integer.parseInt(rateString);
                Preferences.set("serial.debug_rate", rateString);
                try {
                    SerialMonitor.this.close();
                    Thread.sleep(100L);
                    SerialMonitor.this.open();
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        });
        this.onSendCommand(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
    }

    private void send(String s) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    s = s + "\n";
                    break;
                }
                case 2: {
                    s = s + "\r";
                    break;
                }
                case 3: {
                    s = s + "\r\n";
                }
            }
            if ("".equals(s) && this.lineEndings.getSelectedIndex() == 0 && !Preferences.has("runtime.line.ending.alert.notified")) {
                this.noLineEndingAlert.setForeground(Color.RED);
                Preferences.set("runtime.line.ending.alert.notified", "true");
            }
            this.serial.write(s);
        }
    }

    @Override
    public void open() throws Exception {
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.port, this.serialRate){

            protected void message(char[] buff, int n) {
                SerialMonitor.this.addToUpdateBuffer(buff, n);
            }
        };
    }

    @Override
    public void close() throws Exception {
        if (this.serial != null) {
            int[] location = this.getPlacement();
            String locationStr = PApplet.join((String[])PApplet.str((int[])location), (String)",");
            Preferences.set("last.serial.location", locationStr);
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
        }
    }
}

