/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Sketch;
import processing.app.helpers.OSUtils;

public class FindReplace
extends JFrame
implements ActionListener {
    private Editor editor;
    private JTextField findField;
    private JTextField replaceField;
    private static String findString;
    private static String replaceString;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JButton replaceFindButton;
    private JButton previousButton;
    private JButton findButton;
    private JCheckBox ignoreCaseBox;
    private static boolean ignoreCase;
    private JCheckBox wrapAroundBox;
    private static boolean wrapAround;
    private JCheckBox searchAllFilesBox;
    private static boolean searchAllFiles;

    public FindReplace(Editor editor) {
        super(I18n._((String)"Find"));
        this.editor = editor;
        JPanel contentPanel = new JPanel();
        Border padding = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        contentPanel.setBorder(padding);
        this.setContentPane(contentPanel);
        JLabel findLabel = new JLabel(I18n._((String)"Find:"));
        this.findField = new JTextField(20);
        JLabel replaceLabel = new JLabel(I18n._((String)"Replace with:"));
        this.replaceField = new JTextField(20);
        if (editor.getSelectedText() != null && editor.getSelectedText().length() > 0) {
            findString = editor.getSelectedText();
        }
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        this.ignoreCaseBox = new JCheckBox(I18n._((String)"Ignore Case"));
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        this.wrapAroundBox = new JCheckBox(I18n._((String)"Wrap Around"));
        this.wrapAroundBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                wrapAround = FindReplace.this.wrapAroundBox.isSelected();
            }
        });
        this.wrapAroundBox.setSelected(wrapAround);
        this.searchAllFilesBox = new JCheckBox(I18n._((String)"Search all Sketch Tabs"));
        this.searchAllFilesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchAllFiles = FindReplace.this.searchAllFilesBox.isSelected();
            }
        });
        this.searchAllFilesBox.setSelected(searchAllFiles);
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 3));
        checkboxPanel.add(this.ignoreCaseBox);
        checkboxPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        checkboxPanel.add(this.wrapAroundBox);
        checkboxPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        checkboxPanel.add(this.searchAllFilesBox);
        this.replaceAllButton = new JButton(I18n._((String)"Replace All"));
        this.replaceAllButton.addActionListener(this);
        this.replaceButton = new JButton(I18n._((String)"Replace"));
        this.replaceButton.addActionListener(this);
        this.replaceFindButton = new JButton(I18n._((String)"Replace & Find"));
        this.replaceFindButton.addActionListener(this);
        this.previousButton = new JButton(I18n._((String)"Previous"));
        this.previousButton.addActionListener(this);
        this.findButton = new JButton(I18n._((String)"Find"));
        this.findButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        if (OSUtils.isMacOS()) {
            buttonPanel.add(this.replaceAllButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.replaceButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.replaceFindButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.previousButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.findButton);
        } else {
            buttonPanel.add(this.findButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.previousButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.replaceFindButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.replaceButton);
            buttonPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            buttonPanel.add(this.replaceAllButton);
        }
        if (OSUtils.isMacOS()) {
            buttonPanel.setBorder(null);
        }
        GridBagLayout searchLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        Container pane = this.getContentPane();
        pane.setLayout(searchLayout);
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 22;
        pane.add((Component)findLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 21;
        pane.add((Component)this.findField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 22;
        pane.add((Component)replaceLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 21;
        pane.add((Component)this.replaceField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        pane.add((Component)checkboxPanel, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = new Insets(12, 4, 4, 4);
        pane.add((Component)buttonPanel, gbc);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(this.findButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindReplace.this.handleClose();
            }
        });
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        Base.setIcon(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.findButton) {
            this.findNext();
        } else if (source == this.previousButton) {
            this.findPrevious();
        } else if (source == this.replaceFindButton) {
            this.replaceAndFindNext();
        } else if (source == this.replaceButton) {
            this.replace();
        } else if (source == this.replaceAllButton) {
            this.replaceAll();
        }
    }

    private boolean find(boolean wrap, boolean backwards, boolean searchTabs, int originTab) {
        int nextIndex;
        boolean wrapNeeded = false;
        String search = this.findField.getText();
        if (search.length() == 0) {
            return false;
        }
        String text = this.editor.getText();
        if (ignoreCase) {
            search = search.toLowerCase();
            text = text.toLowerCase();
        }
        if (!backwards) {
            int selectionEnd = this.editor.getSelectionStop();
            nextIndex = text.indexOf(search, selectionEnd);
            if (wrap && nextIndex == -1) {
                wrapNeeded = true;
            }
        } else {
            int selectionStart = this.editor.getSelectionStart() - 1;
            nextIndex = selectionStart >= 0 ? text.lastIndexOf(search, selectionStart) : -1;
            if (wrap && nextIndex == -1) {
                wrapNeeded = true;
            }
        }
        if (nextIndex == -1) {
            int realCurrentTab;
            Sketch sketch;
            if (searchTabs && (sketch = this.editor.getSketch()).getCodeCount() > 1 && originTab != (realCurrentTab = sketch.getCodeIndex(sketch.getCurrentCode()))) {
                if (originTab < 0) {
                    originTab = realCurrentTab;
                }
                if (!wrap && (!backwards && realCurrentTab + 1 >= sketch.getCodeCount() || backwards && realCurrentTab - 1 < 0)) {
                    return false;
                }
                if (backwards) {
                    sketch.handlePrevCode();
                    this.setVisible(true);
                    int l = this.editor.getText().length() - 1;
                    this.editor.setSelection(l, l);
                } else {
                    sketch.handleNextCode();
                    this.setVisible(true);
                    this.editor.setSelection(0, 0);
                }
                return this.find(wrap, backwards, searchTabs, originTab);
            }
            if (wrapNeeded) {
                int n = nextIndex = backwards ? text.lastIndexOf(search) : text.indexOf(search, 0);
            }
        }
        if (nextIndex != -1) {
            this.editor.setSelection(nextIndex, nextIndex + search.length());
            return true;
        }
        return false;
    }

    public void replace() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        int newpos = this.editor.getSelectionStart() - this.findField.getText().length();
        if (newpos < 0) {
            newpos = 0;
        }
        this.editor.setSelection(newpos, newpos);
        boolean foundAtLeastOne = false;
        if (this.find(false, false, searchAllFiles, -1)) {
            foundAtLeastOne = true;
            this.editor.setSelectedText(this.replaceField.getText());
            this.editor.getSketch().setModified(true);
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void replaceAndFindNext() {
        this.replace();
        this.findNext();
    }

    public void replaceAll() {
        if (this.findField.getText().length() == 0) {
            return;
        }
        this.editor.setSelection(0, 0);
        boolean foundAtLeastOne = false;
        while (this.find(false, false, searchAllFiles, -1)) {
            foundAtLeastOne = true;
            this.editor.setSelectedText(this.replaceField.getText());
            this.editor.getSketch().setModified(true);
        }
        if (!foundAtLeastOne) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void setFindText(String t) {
        this.findField.setText(t);
        findString = t;
    }

    public void findNext() {
        if (!this.find(wrapAround, false, searchAllFiles, -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findPrevious() {
        if (!this.find(wrapAround, true, searchAllFiles, -1)) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    static {
        ignoreCase = true;
        wrapAround = true;
        searchAllFiles = false;
    }
}

