/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import processing.app.BufferedStyledDocument;
import processing.app.Editor;
import processing.app.EditorConsoleStream;
import processing.app.Preferences;
import processing.app.Theme;
import processing.app.helpers.OSUtils;

public class EditorConsole
extends JScrollPane {
    Editor editor;
    JTextPane consoleTextPane;
    BufferedStyledDocument consoleDoc;
    SimpleAttributeSet stdStyle;
    SimpleAttributeSet errStyle;

    public EditorConsole(Editor _editor) {
        this.editor = _editor;
        int maxLineCount = Preferences.getInteger("console.length");
        this.consoleDoc = new BufferedStyledDocument(4000, maxLineCount);
        this.consoleTextPane = new JTextPane(this.consoleDoc);
        this.consoleTextPane.setEditable(false);
        SimpleAttributeSet leftAlignAttr = new SimpleAttributeSet();
        StyleConstants.setAlignment(leftAlignAttr, 0);
        this.consoleDoc.setParagraphAttributes(0, 0, leftAlignAttr, true);
        Color bgColor = Theme.getColor("console.color");
        Color fgColorOut = Theme.getColor("console.output.color");
        Color fgColorErr = Theme.getColor("console.error.color");
        Font consoleFont = Theme.getFont("console.font");
        Font editorFont = Preferences.getFont("editor.font");
        Font font = new Font(consoleFont.getName(), consoleFont.getStyle(), editorFont.getSize());
        this.stdStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.stdStyle, fgColorOut);
        StyleConstants.setBackground(this.stdStyle, bgColor);
        StyleConstants.setFontSize(this.stdStyle, font.getSize());
        StyleConstants.setFontFamily(this.stdStyle, font.getFamily());
        StyleConstants.setBold(this.stdStyle, font.isBold());
        StyleConstants.setItalic(this.stdStyle, font.isItalic());
        this.errStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errStyle, fgColorErr);
        StyleConstants.setBackground(this.errStyle, bgColor);
        StyleConstants.setFontSize(this.errStyle, font.getSize());
        StyleConstants.setFontFamily(this.errStyle, font.getFamily());
        StyleConstants.setBold(this.errStyle, font.isBold());
        StyleConstants.setItalic(this.errStyle, font.isItalic());
        this.consoleTextPane.setBackground(bgColor);
        this.setViewportView(this.consoleTextPane);
        FontMetrics metrics = this.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        int lines = Preferences.getInteger("console.lines");
        int sizeFudge = 6;
        this.setPreferredSize(new Dimension(1024, height * lines + sizeFudge));
        this.setMinimumSize(new Dimension(1024, height * 4 + sizeFudge));
        EditorConsoleStream.init();
        if (OSUtils.isMacOS()) {
            this.setBorder(null);
        }
        new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (EditorConsole.this.consoleDoc.isChanged()) {
                            EditorConsole.this.consoleDoc.insertAll();
                            EditorConsole.this.consoleTextPane.setCaretPosition(EditorConsole.this.consoleDoc.getLength());
                        }
                    }
                });
            }
        }).start();
    }

    synchronized void appendText(String txt, boolean e) {
        this.consoleDoc.appendString(txt, e ? this.errStyle : this.stdStyle);
    }

    public void clear() {
        try {
            this.consoleDoc.remove(0, this.consoleDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

