/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.jvm;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.plugin2.jvm.JVMEventListener;
import sun.plugin2.jvm.ProcessLauncher;
import sun.plugin2.main.server.AppletID;
import sun.plugin2.message.Conversation;
import sun.plugin2.message.LaunchJVMAppletMessage;
import sun.plugin2.message.Pipe;

public class ProxyJVMLauncher
implements ProcessLauncher,
Runnable {
    private static final boolean DEBUG = false;
    private static final long TIMEOUT = 60000L;
    private static final long INTERVAL = 200L;
    private final int appletID;
    private final Pipe pipe;
    private Conversation conversation;
    private LaunchJVMAppletMessage message;
    private long launchTime;
    private String javaHome;
    private List additionalArguments = new ArrayList();
    private boolean done = false;
    private int exitCode = 0;
    private PipedInputStream in;
    private PipedInputStream err;
    private Exception launchException;
    private Thread thread;
    private boolean sendKill;
    private final ArrayList listeners = new ArrayList();

    public ProxyJVMLauncher(AppletID appletID, Pipe pipe, long l, String string) {
        this.appletID = appletID.getID();
        this.pipe = pipe;
        this.launchTime = l;
        this.javaHome = string;
        this.in = new PipedInputStream();
        this.err = new PipedInputStream();
    }

    public void start() {
        this.thread = this.runThread();
        this.waitForRemoteProcessStarted(60000L);
    }

    protected Thread runThread() {
        Thread thread = new Thread((Runnable)this, this.toString());
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForRemoteProcessStarted(long l) {
        try {
            try {
                long l2 = 0L;
                while (this.message == null || !this.message.isProcessStarted()) {
                    ProxyJVMLauncher proxyJVMLauncher = this;
                    synchronized (proxyJVMLauncher) {
                        this.wait(200L);
                        if ((l2 += 200L) > l) {
                            throw new RuntimeException(this + ": exceeds wait time for remote process");
                        }
                    }
                }
                Object var8_6 = null;
            }
            catch (Exception exception) {
                this.launchException = exception;
                Object var8_7 = null;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    private String[] getAdditionalArgs() {
        String[] stringArray = new String[this.additionalArguments.size()];
        return this.additionalArguments.toArray(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                this.conversation = this.pipe.beginConversation();
                this.message = new LaunchJVMAppletMessage(this.conversation, this.appletID, this.javaHome, this.launchTime, this.getAdditionalArgs());
                this.pipe.send(this.message);
                PipedOutputStream pipedOutputStream = new PipedOutputStream(this.in);
                PipedOutputStream pipedOutputStream2 = new PipedOutputStream(this.err);
                while (!this.done) {
                    LaunchJVMAppletMessage launchJVMAppletMessage = (LaunchJVMAppletMessage)this.pipe.receive(60000L, this.conversation);
                    if (launchJVMAppletMessage == null) {
                        ProxyJVMLauncher proxyJVMLauncher = this;
                        synchronized (proxyJVMLauncher) {
                            this.wait(200L);
                            continue;
                        }
                    }
                    this.message = launchJVMAppletMessage;
                    if (this.message.getProcessInputBytes() != null) {
                        pipedOutputStream.write(this.message.getProcessInputBytes());
                        ((OutputStream)pipedOutputStream).flush();
                    }
                    if (this.message.getProcessErrorBytes() != null) {
                        pipedOutputStream2.write(this.message.getProcessErrorBytes());
                        ((OutputStream)pipedOutputStream2).flush();
                    }
                    this.done = this.message.isProcessExited();
                    if (this.done) {
                        System.out.println("ProxyJVMLauncher: remote process exited.");
                        this.exitCode = this.message.getProcessExitCode();
                        break;
                    }
                    if (!this.sendKill) continue;
                    System.out.println("ProxyJVMLauncher: sending kill " + this.message);
                    this.message.setDoKill(true);
                    this.sendKill = false;
                    this.pipe.send(this.message);
                }
                Object var7_7 = null;
            }
            catch (Exception exception) {
                this.launchException = exception;
                System.out.println("ProxyJVMLauncher.run() got error ");
                exception.printStackTrace();
                Object var7_8 = null;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            throw throwable;
        }
    }

    public void launchCompleted() {
        this.done = true;
    }

    public void addParameter(String string) {
        this.additionalArguments.add(string);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public InputStream getErrorStream() {
        return this.err;
    }

    public boolean processStarted() {
        return this.message.isProcessStarted();
    }

    public boolean exited() {
        return this.done;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public long getJVMLaunchTime() {
        return this.launchTime;
    }

    public Exception getErrorDuringStartup() {
        return this.launchException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJVMEventListener(JVMEventListener jVMEventListener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(jVMEventListener);
        }
    }

    public void clearUserArguments() {
    }

    public void destroy() {
        if (this.thread.isAlive()) {
            this.sendKill = true;
        } else {
            this.done = true;
        }
    }

    private synchronized List copyListeners() {
        return (List)this.listeners.clone();
    }

    private void fireJVMExited() {
        Iterator iterator = this.copyListeners().iterator();
        while (iterator.hasNext()) {
            JVMEventListener jVMEventListener = (JVMEventListener)iterator.next();
            jVMEventListener.jvmExited(this);
        }
    }

    public String toString() {
        return "ProxyJVMLauncher(appletID=" + this.appletID + ")";
    }
}

