/*
 * Decompiled with CFR 0.152.
 */
package processing.app.windows;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;
import processing.app.tools.ExternalProcessExecutor;
import processing.app.windows.ListComPortsParser;
import processing.app.windows.Registry;

public class Platform
extends processing.app.Platform {
    static final String openCommand = System.getProperty("user.dir").replace('/', '\\') + "\\arduino.exe \"%1\"";
    static final String DOC = "Arduino.Document";
    static WinLibC clib = (WinLibC)Native.loadLibrary((String)"msvcrt", WinLibC.class);

    @Override
    public void init() {
        super.init();
        this.checkAssociations();
        this.checkQuickTime();
        this.checkPath();
    }

    protected void checkAssociations() {
        try {
            String string = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open\\command", "");
            if (string == null) {
                if (PreferencesData.getBoolean("platform.auto_file_type_associations")) {
                    this.setAssociations();
                }
            } else if (!string.equals(openCommand) && PreferencesData.getBoolean("platform.auto_file_type_associations")) {
                this.setAssociations();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setAssociations() throws UnsupportedEncodingException {
        if (!(Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", ".ino") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, ".ino", "", DOC) && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "", DOC) && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "", "Arduino Source Code") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, DOC, "shell") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell", "open") && Registry.createKey(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open", "command") && Registry.setStringValue(Registry.REGISTRY_ROOT_KEY.CLASSES_ROOT, "Arduino.Document\\shell\\open\\command", "", openCommand))) {
            PreferencesData.setBoolean("platform.auto_file_type_associations", false);
        }
    }

    protected void checkQuickTime() {
        try {
            File file;
            String string = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.LOCAL_MACHINE, "Software\\Apple Computer, Inc.\\QuickTime", "QTSysDir");
            if (string != null && (file = new File(string, "QTJava.zip")).exists()) {
                String string2 = file.getAbsolutePath();
                String string3 = System.getProperty("java.class.path");
                System.setProperty("java.class.path", string3 + File.pathSeparator + string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
    }

    protected void checkPath() {
        String string = System.getProperty("java.library.path");
        String[] stringArray = PApplet.split(string, File.pathSeparatorChar);
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            File file;
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.endsWith(File.separator)) {
                string2 = string2.substring(0, string2.length() - File.separator.length());
            }
            if (!(file = new File(string2)).exists() || string2.trim().length() == 0) continue;
            stringArray2[n++] = string2;
        }
        String string3 = PApplet.join(stringArray2 = PApplet.subset(stringArray2, 0, n), File.pathSeparator);
        if (!string3.equals(string)) {
            System.setProperty("java.library.path", string3);
        }
    }

    @Override
    public File getSettingsFolder() throws Exception {
        String string = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String string2 = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, string, "AppData");
        File file = new File(string2, "Arduino15");
        return file;
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        String string = "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
        String string2 = Registry.getStringValue(Registry.REGISTRY_ROOT_KEY.CURRENT_USER, string, "Personal");
        return new File(string2, "Arduino");
    }

    @Override
    public void openURL(String string) throws Exception {
        if (string.startsWith("http://")) {
            Runtime.getRuntime().exec("cmd /c start " + string);
        } else {
            Runtime.getRuntime().exec("cmd /c \"" + string + "\"");
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        String string = file.getAbsolutePath();
        Runtime.getRuntime().exec("explorer \"" + string + "\"");
    }

    @Override
    public void setenv(String string, String string2) {
        clib._putenv(string + "=" + string2);
    }

    @Override
    public String getenv(String string) {
        return System.getenv(string);
    }

    @Override
    public int unsetenv(String string) {
        return clib._putenv(string + "=");
    }

    @Override
    public String getName() {
        return PConstants.platformNames[1];
    }

    @Override
    public String resolveDeviceAttachedTo(String string, Map<String, TargetPackage> map, String string2) {
        if (string2 == null) {
            return super.resolveDeviceAttachedTo(string, map, string2);
        }
        try {
            String string3 = new ListComPortsParser().extractVIDAndPID(string2, string);
            if (string3 == null) {
                return super.resolveDeviceAttachedTo(string, map, string2);
            }
            return super.resolveDeviceByVendorIdProductId(map, string3);
        }
        catch (IOException iOException) {
            return super.resolveDeviceAttachedTo(string, map, string2);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExternalProcessExecutor externalProcessExecutor = new ExternalProcessExecutor(byteArrayOutputStream);
        try {
            String string = new File(System.getProperty("user.dir"), "hardware/tools/listComPorts.exe").getCanonicalPath();
            CommandLine commandLine = CommandLine.parse((String)string);
            externalProcessExecutor.execute(commandLine);
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            return super.preListAllCandidateDevices();
        }
    }

    public static interface WinLibC
    extends Library {
        public int _putenv(String var1);
    }
}

