/*
 * Decompiled with CFR 0.152.
 */
package processing.app.macosx;

import com.apple.eio.FileManager;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import javax.swing.UIManager;
import org.apache.commons.exec.CommandLine;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;
import processing.app.macosx.SystemProfilerParser;
import processing.app.tools.ExternalProcessExecutor;

public class Platform
extends processing.app.Platform {
    static final int kDocumentsFolderType = 1685021555;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;

    @Override
    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
        UIManager.put("Component.visualMargin", new Insets(1, 1, 1, 1));
    }

    public Platform() {
        Toolkit.getDefaultToolkit();
    }

    @Override
    public void init() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Arduino15");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Arduino");
    }

    @Override
    public void openURL(String string) throws Exception {
        if (PApplet.javaVersion < 1.6f) {
            if (string.startsWith("http://")) {
                try {
                    Class<?> clazz = Class.forName("com.apple.eio.FileManager");
                    Method method = clazz.getMethod("openURL", String.class);
                    method.invoke(null, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                PApplet.open(string);
            }
        } else {
            try {
                Class<?> clazz = Class.forName("java.awt.Desktop");
                Method method = clazz.getMethod("getDesktop", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (string.startsWith("http://")) {
                    Method method2 = clazz.getMethod("browse", URI.class);
                    method2.invoke(object, new URI(string));
                } else {
                    Method method3 = clazz.getMethod("open", File.class);
                    method3.invoke(object, new File(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public boolean openFolderAvailable() {
        return true;
    }

    @Override
    public void openFolder(File file) throws Exception {
        PApplet.open(file.getAbsolutePath());
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }

    @Override
    public String getName() {
        return PConstants.platformNames[2];
    }

    @Override
    public String resolveDeviceAttachedTo(String string, Map<String, TargetPackage> map, String string2) {
        if (string2 == null) {
            return super.resolveDeviceAttachedTo(string, map, string2);
        }
        try {
            String string3 = new SystemProfilerParser().extractVIDAndPID(string2, string);
            if (string3 == null) {
                return super.resolveDeviceAttachedTo(string, map, string2);
            }
            return super.resolveDeviceByVendorIdProductId(map, string3);
        }
        catch (IOException iOException) {
            return super.resolveDeviceAttachedTo(string, map, string2);
        }
    }

    @Override
    public String preListAllCandidateDevices() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExternalProcessExecutor externalProcessExecutor = new ExternalProcessExecutor(byteArrayOutputStream);
        try {
            CommandLine commandLine = CommandLine.parse((String)"/usr/sbin/system_profiler SPUSBDataType");
            externalProcessExecutor.execute(commandLine);
            return new String(byteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            return super.preListAllCandidateDevices();
        }
    }
}

