/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import processing.app.I18n;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.filefilters.OnlyDirs;

public class TargetPackage {
    private String id;
    Map<String, TargetPlatform> platforms = new LinkedHashMap<String, TargetPlatform>();

    public TargetPackage(String string, File file) throws TargetPlatformException {
        this.id = string;
        File[] fileArray = file.listFiles(new OnlyDirs());
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (!file2.exists() || !file2.canRead()) continue;
            String string2 = file2.getName();
            try {
                TargetPlatform targetPlatform = new TargetPlatform(string2, file2, this);
                this.platforms.put(string2, targetPlatform);
            }
            catch (TargetPlatformException targetPlatformException) {
                System.out.println(targetPlatformException.getMessage());
            }
        }
        if (this.platforms.size() == 0) {
            throw new TargetPlatformException(I18n.format(I18n._("No valid hardware definitions found in folder {0}."), file.getName()));
        }
    }

    public Map<String, TargetPlatform> getPlatforms() {
        return this.platforms;
    }

    public Collection<TargetPlatform> platforms() {
        return this.platforms.values();
    }

    public TargetPlatform get(String string) {
        return this.platforms.get(string);
    }

    public String getId() {
        return this.id;
    }
}

