/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.SketchCode;

public class SketchData {
    private File primaryFile;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private String name;
    private List<SketchCode> codes = new ArrayList<SketchCode>();
    private static final Comparator<SketchCode> CODE_DOCS_COMPARATOR = new Comparator<SketchCode>(){

        @Override
        public int compare(SketchCode sketchCode, SketchCode sketchCode2) {
            return sketchCode.getFileName().compareTo(sketchCode2.getFileName());
        }
    };

    SketchData(File file) {
        this.primaryFile = file;
        String string = this.primaryFile.getName();
        int n = this.getDefaultExtension().length() + 1;
        this.name = string.substring(0, string.length() - n);
        this.folder = new File(file.getParent());
    }

    public static File checkSketchFile(File file) {
        String string = file.getName();
        File file2 = file.getParentFile();
        String string2 = file2.getName();
        String string3 = string2 + ".pde";
        File file3 = new File(file2, string3);
        String string4 = string2 + ".ino";
        File file4 = new File(file2, string4);
        if (string3.equals(string) || string4.equals(string)) {
            return file;
        }
        if (file3.exists()) {
            return file3;
        }
        if (file4.exists()) {
            return file4;
        }
        return null;
    }

    protected void load() throws IOException {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        String[] stringArray = this.folder.list();
        this.clearCodeDocs();
        List<String> list = this.getExtensions();
        for (String object : stringArray) {
            if (object.startsWith(".") || new File(this.folder, object).isDirectory()) continue;
            String string = object;
            for (String string2 : list) {
                if (!string.toLowerCase().endsWith("." + string2)) continue;
                if (BaseNoGui.isSanitaryName(string = string.substring(0, string.length() - (string2.length() + 1)))) {
                    this.addCode(new SketchCode(new File(this.folder, object)));
                    continue;
                }
                System.err.println(I18n.format("File name {0} is invalid: ignored", object));
            }
        }
        if (this.getCodeCount() == 0) {
            throw new IOException(I18n._("No valid code files found"));
        }
        for (SketchCode sketchCode : this.getCodes()) {
            if (!sketchCode.getFile().equals(this.primaryFile)) continue;
            this.moveCodeToFront(sketchCode);
            break;
        }
        this.sortCode();
    }

    public void save() throws IOException {
        for (SketchCode sketchCode : this.getCodes()) {
            if (!sketchCode.isModified()) continue;
            sketchCode.save();
        }
    }

    public int getCodeCount() {
        return this.codes.size();
    }

    public SketchCode[] getCodes() {
        return this.codes.toArray(new SketchCode[0]);
    }

    public String getDefaultExtension() {
        return "ino";
    }

    public List<String> getExtensions() {
        return Arrays.asList("ino", "pde", "c", "cpp", "h");
    }

    public File getPrimaryFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public void addCode(SketchCode sketchCode) {
        this.codes.add(sketchCode);
    }

    public void moveCodeToFront(SketchCode sketchCode) {
        this.codes.remove(sketchCode);
        this.codes.add(0, sketchCode);
    }

    protected void replaceCode(SketchCode sketchCode) {
        for (SketchCode sketchCode2 : this.codes) {
            if (!sketchCode2.getFileName().equals(sketchCode.getFileName())) continue;
            this.codes.set(this.codes.indexOf(sketchCode2), sketchCode);
            return;
        }
    }

    protected void sortCode() {
        if (this.codes.size() < 2) {
            return;
        }
        SketchCode sketchCode = this.codes.remove(0);
        Collections.sort(this.codes, CODE_DOCS_COMPARATOR);
        this.codes.add(0, sketchCode);
    }

    public SketchCode getCode(int n) {
        return this.codes.get(n);
    }

    protected void removeCode(SketchCode sketchCode) {
        for (SketchCode sketchCode2 : this.codes) {
            if (sketchCode2 != sketchCode) continue;
            this.codes.remove(sketchCode2);
            return;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public int indexOfCode(SketchCode sketchCode) {
        for (SketchCode sketchCode2 : this.codes) {
            if (sketchCode2 != sketchCode) continue;
            return this.codes.indexOf(sketchCode2);
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void clearCodeDocs() {
        this.codes.clear();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }
}

