/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.MissingResourceException;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.PreferencesMap;
import processing.app.legacy.PApplet;
import processing.app.legacy.PConstants;

public class PreferencesData {
    static final String PREFS_FILE = "preferences.txt";
    static PreferencesMap defaults;
    static PreferencesMap prefs;
    static File preferencesFile;
    static boolean doSave;

    public static void init(File file) {
        preferencesFile = file != null ? file : BaseNoGui.getSettingsFile(PREFS_FILE);
        try {
            prefs.load(BaseNoGui.getLibStream(PREFS_FILE));
        }
        catch (IOException iOException) {
            BaseNoGui.showError(null, I18n._("Could not read default settings.\nYou'll need to reinstall Arduino."), iOException);
        }
        File file2 = BaseNoGui.getHardwareFolder();
        prefs.put("runtime.ide.path", file2.getParentFile().getAbsolutePath());
        prefs.put("runtime.ide.version", "10600");
        defaults = new PreferencesMap(prefs);
        if (preferencesFile.exists()) {
            try {
                prefs.load(preferencesFile);
            }
            catch (IOException iOException) {
                BaseNoGui.showError(I18n._("Error reading preferences"), I18n.format(I18n._("Error reading the preferences file. Please delete (or move)\n{0} and restart Arduino."), preferencesFile.getAbsolutePath()), iOException);
            }
        }
        try {
            I18n.init(PreferencesData.get("editor.languages.current"));
        }
        catch (MissingResourceException missingResourceException) {
            I18n.init("en");
            PreferencesData.set("editor.languages.current", "en");
        }
        PreferencesData.set("runtime.os", PConstants.platformNames[PApplet.platform]);
        PreferencesData.fixPreferences();
    }

    private static void fixPreferences() {
        String string = PreferencesData.get("serial.debug_rate");
        if ("14400".equals(string) || "28800".equals(string)) {
            PreferencesData.set("serial.debug_rate", "9600");
        }
    }

    public static String[] loadStrings(InputStream inputStream) {
        try {
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String[] stringArray2 = new String[100];
            int n = 0;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (n == stringArray2.length) {
                    stringArray = new String[n << 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, n);
                    stringArray2 = stringArray;
                }
                stringArray2[n++] = string;
            }
            bufferedReader.close();
            if (n == stringArray2.length) {
                return stringArray2;
            }
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected static void save() {
        if (!doSave) {
            return;
        }
        if (preferencesFile == null) {
            return;
        }
        PrintWriter printWriter = PApplet.createWriter(preferencesFile);
        Object[] objectArray = prefs.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            if (((String)object).startsWith("runtime.")) continue;
            printWriter.println((String)object + "=" + (String)prefs.get(object));
        }
        printWriter.flush();
        printWriter.close();
    }

    public static String get(String string) {
        return (String)prefs.get(string);
    }

    public static String get(String string, String string2) {
        String string3 = PreferencesData.get(string);
        return string3 == null ? string2 : string3;
    }

    public static boolean has(String string) {
        return prefs.containsKey(string);
    }

    public static void remove(String string) {
        prefs.remove(string);
    }

    public static String getDefault(String string) {
        return (String)defaults.get(string);
    }

    public static void set(String string, String string2) {
        prefs.put(string, string2);
    }

    public static void unset(String string) {
        prefs.remove(string);
    }

    public static boolean getBoolean(String string) {
        return prefs.getBoolean(string);
    }

    public static void setBoolean(String string, boolean bl) {
        prefs.putBoolean(string, bl);
    }

    public static int getInteger(String string) {
        return Integer.parseInt(PreferencesData.get(string));
    }

    public static void setInteger(String string, int n) {
        PreferencesData.set(string, String.valueOf(n));
    }

    public static PreferencesMap getMap() {
        return new PreferencesMap(prefs);
    }

    public static void setDoSave(boolean bl) {
        doSave = bl;
    }

    static {
        prefs = new PreferencesMap();
        doSave = true;
    }
}

