/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.uploaders;

import cc.arduino.packages.Uploader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.StringReplacer;

public class SerialUploader
extends Uploader {
    public SerialUploader() {
    }

    public SerialUploader(boolean bl) {
        super(bl);
    }

    @Override
    public boolean uploadUsingPreferences(File file, String string, String string2, boolean bl, List<String> list) throws Exception {
        boolean bl2;
        Object object;
        boolean bl3;
        Object object2;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        PreferencesMap preferencesMap = PreferencesData.getMap();
        preferencesMap.putAll(BaseNoGui.getBoardPreferences());
        String string3 = preferencesMap.getOrExcept("upload.tool");
        if (string3.contains(":")) {
            object2 = string3.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(object2[0]);
            string3 = object2[1];
        }
        preferencesMap.putAll(targetPlatform.getTool(string3));
        if (bl || preferencesMap.get("upload.protocol") == null) {
            return this.uploadUsingProgrammer(string, string2);
        }
        if (this.noUploadPort) {
            boolean bl4;
            preferencesMap.put("build.path", string);
            preferencesMap.put("build.project_name", string2);
            if (this.verbose) {
                preferencesMap.put("upload.verbose", preferencesMap.getOrExcept("upload.params.verbose"));
            } else {
                preferencesMap.put("upload.verbose", preferencesMap.getOrExcept("upload.params.quiet"));
            }
            try {
                String string4 = preferencesMap.getOrExcept("upload.pattern");
                String[] stringArray = StringReplacer.formatAndSplit(string4, preferencesMap, true);
                bl4 = this.executeUploadCommand(stringArray);
            }
            catch (Exception exception) {
                throw new RunnerException(exception);
            }
            return bl4;
        }
        object2 = (String)preferencesMap.get("upload.use_1200bps_touch");
        boolean bl5 = object2 != null && ((String)object2).equals("true");
        object2 = (String)preferencesMap.get("upload.wait_for_upload_port");
        boolean bl6 = bl3 = object2 != null && ((String)object2).equals("true");
        if (bl5) {
            String string5 = preferencesMap.getOrExcept("serial.port");
            try {
                object = Serial.list();
                if (object.contains(string5)) {
                    if (this.verbose) {
                        System.out.println(I18n.format(I18n._("Forcing reset using 1200bps open/close on port {0}"), string5));
                    }
                    Serial.touchPort(string5, 1200);
                }
                Thread.sleep(400L);
                if (bl3) {
                    string5 = this.waitForUploadPort(string5, (List<String>)object);
                }
            }
            catch (SerialException serialException) {
                throw new RunnerException(serialException);
            }
            catch (InterruptedException interruptedException) {
                throw new RunnerException(interruptedException.getMessage());
            }
            preferencesMap.put("serial.port", string5);
            if (string5.startsWith("/dev/")) {
                preferencesMap.put("serial.port.file", string5.substring(5));
            } else {
                preferencesMap.put("serial.port.file", string5);
            }
        }
        preferencesMap.put("build.path", string);
        preferencesMap.put("build.project_name", string2);
        if (this.verbose) {
            preferencesMap.put("upload.verbose", preferencesMap.getOrExcept("upload.params.verbose"));
        } else {
            preferencesMap.put("upload.verbose", preferencesMap.getOrExcept("upload.params.quiet"));
        }
        try {
            object = preferencesMap.getOrExcept("upload.pattern");
            String[] stringArray = StringReplacer.formatAndSplit((String)object, preferencesMap, true);
            bl2 = this.executeUploadCommand(stringArray);
        }
        catch (RunnerException runnerException) {
            throw runnerException;
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
        try {
            if (bl2 && bl5) {
                object = PreferencesData.get("serial.port");
                if (bl3) {
                    List<String> list2;
                    Thread.sleep(1000L);
                    long l = System.currentTimeMillis();
                    while (System.currentTimeMillis() - l < 2000L && !(list2 = Serial.list()).contains(object)) {
                        Thread.sleep(250L);
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return bl2;
    }

    private String waitForUploadPort(String string, List<String> list) throws InterruptedException, RunnerException {
        int n = 0;
        while (n < 10000) {
            List<String> list2 = Serial.list();
            ArrayList<String> arrayList = new ArrayList<String>(list2);
            arrayList.removeAll(list);
            if (this.verbose) {
                System.out.print("PORTS {");
                for (String string2 : list) {
                    System.out.print(string2 + ", ");
                }
                System.out.print("} / {");
                for (String string2 : list2) {
                    System.out.print(string2 + ", ");
                }
                System.out.print("} => {");
                for (String string2 : arrayList) {
                    System.out.print(string2 + ", ");
                }
                System.out.println("}");
            }
            if (arrayList.size() > 0) {
                Iterator<String> iterator = (String)arrayList.get(0);
                if (this.verbose) {
                    System.out.println("Found upload port: " + iterator);
                }
                return iterator;
            }
            list = list2;
            Thread.sleep(250L);
            if ((OSUtils.isWindows() || (n += 250) < 500) && n < 5000 || !list2.contains(string)) continue;
            if (this.verbose) {
                System.out.println("Uploading using selected port: " + string);
            }
            return string;
        }
        throw new RunnerException(I18n._("Couldn't find a Board on the selected port. Check that you have the correct port selected.  If it is correct, try pressing the board's reset button after initiating the upload."));
    }

    public boolean uploadUsingProgrammer(String string, String string2) throws Exception {
        String[] stringArray;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        String string3 = PreferencesData.get("programmer");
        if (string3.contains(":")) {
            stringArray = string3.split(":", 2);
            targetPlatform = BaseNoGui.getCurrentTargetPlatformFromPackage(stringArray[0]);
            string3 = stringArray[1];
        }
        stringArray = PreferencesData.getMap();
        stringArray.putAll(BaseNoGui.getBoardPreferences());
        PreferencesMap preferencesMap = targetPlatform.getProgrammer(string3);
        if (preferencesMap == null) {
            throw new RunnerException(I18n._("Please select a programmer from Tools->Programmer menu"));
        }
        stringArray.putAll(preferencesMap);
        stringArray.putAll(targetPlatform.getTool(stringArray.getOrExcept("program.tool")));
        stringArray.put("build.path", string);
        stringArray.put("build.project_name", string2);
        if (this.verbose) {
            stringArray.put("program.verbose", stringArray.getOrExcept("program.params.verbose"));
        } else {
            stringArray.put("program.verbose", stringArray.getOrExcept("program.params.quiet"));
        }
        try {
            String string4 = stringArray.getOrExcept("program.pattern");
            String[] stringArray2 = StringReplacer.formatAndSplit(string4, (Map<String, String>)stringArray, true);
            return this.executeUploadCommand(stringArray2);
        }
        catch (RunnerException runnerException) {
            throw runnerException;
        }
        catch (Exception exception) {
            throw new RunnerException(exception);
        }
    }

    @Override
    public boolean burnBootloader() throws Exception {
        String[] stringArray;
        Object object;
        PreferencesMap preferencesMap;
        Object object2;
        Object object3;
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        Object object4 = PreferencesData.get("programmer");
        if (((String)object4).contains(":")) {
            object3 = ((String)object4).split(":", 2);
            object2 = BaseNoGui.getCurrentTargetPlatformFromPackage(object3[0]);
            object4 = object3[1];
            preferencesMap = ((TargetPlatform)object2).getProgrammer((String)object4);
        } else {
            preferencesMap = targetPlatform.getProgrammer((String)object4);
        }
        if (preferencesMap == null) {
            throw new RunnerException(I18n._("Please select a programmer from Tools->Programmer menu"));
        }
        object3 = PreferencesData.getMap();
        ((HashMap)object3).putAll(BaseNoGui.getBoardPreferences());
        ((HashMap)object3).putAll(preferencesMap);
        object2 = new PreferencesMap();
        String string = ((PreferencesMap)object3).getOrExcept("bootloader.tool");
        if (string.contains(":")) {
            object = string.split(":", 2);
            stringArray = BaseNoGui.getCurrentTargetPlatformFromPackage(object[0]);
            string = object[1];
            ((HashMap)object2).putAll(stringArray.getTool(string));
            if (((HashMap)object2).size() == 0) {
                throw new RunnerException(I18n.format(I18n._("Could not find tool {0} from package {1}"), string, object[0]));
            }
        }
        ((HashMap)object2).putAll(targetPlatform.getTool(string));
        if (((HashMap)object2).size() == 0) {
            throw new RunnerException(I18n.format(I18n._("Could not find tool {0}"), string));
        }
        ((HashMap)object3).putAll(object2);
        if (this.verbose) {
            ((HashMap)object3).put("erase.verbose", ((PreferencesMap)object3).getOrExcept("erase.params.verbose"));
            ((HashMap)object3).put("bootloader.verbose", ((PreferencesMap)object3).getOrExcept("bootloader.params.verbose"));
        } else {
            ((HashMap)object3).put("erase.verbose", ((PreferencesMap)object3).getOrExcept("erase.params.quiet"));
            ((HashMap)object3).put("bootloader.verbose", ((PreferencesMap)object3).getOrExcept("bootloader.params.quiet"));
        }
        object = ((PreferencesMap)object3).getOrExcept("erase.pattern");
        stringArray = StringReplacer.formatAndSplit((String)object, (Map<String, String>)object3, true);
        if (!this.executeUploadCommand(stringArray)) {
            return false;
        }
        object = ((PreferencesMap)object3).getOrExcept("bootloader.pattern");
        stringArray = StringReplacer.formatAndSplit((String)object, (Map<String, String>)object3, true);
        return this.executeUploadCommand(stringArray);
    }
}

