/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_KR;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;

public class ISO2022_KR
extends ISO2022
implements HistoricallyNamedCharset {
    private static Charset ksc5601_cs;

    public ISO2022_KR() {
        super("ISO-2022-KR", ExtendedCharsets.aliasesFor("ISO-2022-KR"));
        ksc5601_cs = new EUC_KR();
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof EUC_KR || charset.name().equals("US-ASCII") || charset instanceof ISO2022_KR;
    }

    @Override
    public String historicalName() {
        return "ISO2022KR";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends ISO2022.Decoder {
        public Decoder(Charset charset) {
            super(charset);
            this.SODesig = new byte[][]{{36, 41, 67}};
            this.SODecoder = new CharsetDecoder[1];
            try {
                this.SODecoder[0] = ksc5601_cs.newDecoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Encoder
    extends ISO2022.Encoder {
        public Encoder(Charset charset) {
            super(charset);
            this.SODesig = "$)C";
            try {
                this.ISOEncoder = ksc5601_cs.newEncoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean canEncode(char c) {
            return this.ISOEncoder.canEncode(c);
        }
    }
}

