/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.AdvancedProperties;
import com.sun.deploy.panel.JSmartTextArea;
import com.sun.deploy.panel.SecurityLevel;
import com.sun.deploy.panel.SecurityProperties;
import com.sun.deploy.resources.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SecurityLevelPanel
extends JPanel
implements SecurityProperties.JavaEnableListener,
AdvancedProperties.NewPluginEnableListener {
    private JSlider slider;
    private JSmartTextArea text;
    private boolean sliderStateChanged;

    public SecurityLevelPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(new EmptyBorder(new Insets(5, 15, 5, 15)));
        Box box = Box.createVerticalBox();
        box.add(this.createSecurityLabel());
        JComponent jComponent = this.getSliderPanel();
        box.add(jComponent);
        box.add(this.createTextComponent());
        this.add(box);
    }

    private JComponent createSecurityLabel() {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel(ResourceManager.getMessage("deployment.security.level.title"));
        box.add(Box.createRigidArea(new Dimension(10, jLabel.getPreferredSize().height)));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JComponent createTextComponent() {
        Box box = Box.createHorizontalBox();
        this.text = new JSmartTextArea("");
        int n = this.text.getPreferredSize().height * 4;
        this.text.setPreferredSize(new Dimension(this.text.preferred_width, n));
        boolean bl = Platform.get().getJavaPluginSettings();
        this.updateTextComponent(bl);
        box.add(this.text);
        return box;
    }

    private JComponent getSliderPanel() {
        JPanel jPanel = new JPanel();
        Box box = Box.createHorizontalBox();
        JComponent jComponent = this.createSlider();
        Dimension dimension = jComponent.getPreferredSize();
        jPanel.add(jComponent);
        JComponent jComponent2 = this.createLevelIconsPanel(dimension);
        box.add(jComponent2);
        box.add(jComponent);
        jPanel.add(box);
        return jPanel;
    }

    private JComponent createLevelIconsPanel(Dimension dimension) {
        Box box = Box.createVerticalBox();
        int n = (int)(dimension.getHeight() / 5.0);
        ImageIcon imageIcon = ResourceManager.getIcon("security.images.secure.lock");
        int n2 = 32;
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setPreferredSize(new Dimension(n2, n));
        box.add(jLabel);
        box.add(Box.createGlue());
        box.add(Box.createRigidArea(new Dimension(n2, n)));
        box.add(Box.createGlue());
        box.add(Box.createRigidArea(new Dimension(n2, n)));
        box.add(Box.createGlue());
        return box;
    }

    private JComponent createSlider() {
        this.slider = new JSlider();
        this.slider.setOrientation(1);
        this.slider.setMinimum(SecurityLevel.Medium.getSliderSetting());
        this.slider.setMaximum(SecurityLevel.VeryHigh.getSliderSetting());
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        SecurityLevel securityLevel = SecurityLevel.VeryHigh;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        securityLevel = SecurityLevel.High;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        securityLevel = SecurityLevel.Medium;
        hashtable.put(new Integer(securityLevel.getSliderSetting()), new JLabel(securityLevel.getName()));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.slider.setLabelTable(hashtable);
        this.slider.setPaintTicks(true);
        this.slider.setPaintLabels(true);
        this.slider.setSnapToTicks(true);
        this.slider.setMinorTickSpacing(1);
        this.slider.setValue(SecurityProperties.getProposedSecurityLevel().getSliderSetting());
        Dimension dimension = this.slider.getPreferredSize();
        this.slider.setPreferredSize(new Dimension(dimension.width + 40, dimension.height - 20));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SecurityLevelPanel.this.sliderStateChanged = true;
            }
        });
        this.slider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SecurityLevelPanel.this.setSlider();
                SecurityLevelPanel.this.sliderStateChanged = false;
            }
        });
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SecurityLevelPanel.this.setSlider();
                SecurityLevelPanel.this.sliderStateChanged = false;
            }
        });
        boolean bl = Platform.get().getJavaPluginSettings();
        this.enableSecuritySlider(SecurityProperties.isJavaInBrowserEnabled(), bl);
        SecurityProperties.addJavaEnableListener(this);
        AdvancedProperties.addStatusChangedListener(this);
        return this.slider;
    }

    private void enableSecuritySlider(boolean bl, boolean bl2) {
        this.slider.setEnabled(bl && bl2 && !Config.get().isPropertyLocked("deployment.security.level"));
        this.slider.invalidate();
    }

    private void updateTextComponent(boolean bl) {
        if (!bl && SecurityProperties.isJavaInBrowserEnabled()) {
            this.text.setText(AdvancedProperties.getOldPluginSliderDescription());
        } else {
            this.text.setText(SecurityProperties.getProposedSecurityLevel().getDescription());
        }
    }

    public void javaEnableChanged(SecurityProperties.JavaEnableEvent javaEnableEvent) {
        this.enableSecuritySlider(javaEnableEvent.isEnabled(), Platform.get().getJavaPluginSettings());
        this.updateTextComponent(Platform.get().getJavaPluginSettings());
    }

    public void newPluginEnableChanged(AdvancedProperties.NewPluginEnableEvent newPluginEnableEvent) {
        this.enableSecuritySlider(SecurityProperties.isJavaInBrowserEnabled(), newPluginEnableEvent.isEnabled());
        this.updateTextComponent(newPluginEnableEvent.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSlider() {
        try {
            SecurityLevel securityLevel = SecurityProperties.getProposedSecurityLevel();
            int n = this.slider.getValue();
            SecurityLevel securityLevel2 = SecurityLevel.getSliderSetting(n);
            if (this.sliderStateChanged && securityLevel2 != securityLevel) {
                SecurityProperties.setProposedSecurityLevel(n);
                this.text.setText(securityLevel2.getDescription());
            }
            Object var5_4 = null;
            this.sliderStateChanged = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.sliderStateChanged = false;
            throw throwable;
        }
    }
}

