/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.finder;

import com.sun.beans.WeakCache;
import com.sun.beans.finder.AbstractFinder;
import com.sun.beans.finder.PrimitiveWrapperMap;
import com.sun.beans.finder.Signature;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import sun.reflect.misc.ReflectUtil;

public final class ConstructorFinder
extends AbstractFinder<Constructor<?>> {
    private static final WeakCache<Signature, Constructor<?>> CACHE = new WeakCache();

    public static Constructor<?> findConstructor(Class<?> clazz, Class<?> ... classArray) throws NoSuchMethodException {
        if (clazz.isPrimitive()) {
            throw new NoSuchMethodException("Primitive wrapper does not contain constructors");
        }
        if (clazz.isInterface()) {
            throw new NoSuchMethodException("Interface does not contain constructors");
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new NoSuchMethodException("Abstract class cannot be instantiated");
        }
        if (!Modifier.isPublic(clazz.getModifiers()) || !ReflectUtil.isPackageAccessible(clazz)) {
            throw new NoSuchMethodException("Class is not accessible");
        }
        PrimitiveWrapperMap.replacePrimitivesWithWrappers(classArray);
        Signature signature = new Signature(clazz, classArray);
        Constructor constructor = CACHE.get(signature);
        if (constructor != null) {
            return constructor;
        }
        constructor = (Constructor)new ConstructorFinder(classArray).find(clazz.getConstructors());
        CACHE.put(signature, constructor);
        return constructor;
    }

    private ConstructorFinder(Class<?>[] classArray) {
        super(classArray);
    }

    @Override
    protected Class<?>[] getParameters(Constructor<?> constructor) {
        return constructor.getParameterTypes();
    }

    @Override
    protected boolean isVarArgs(Constructor<?> constructor) {
        return constructor.isVarArgs();
    }
}

