/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.Utils;
import com.sun.javafx.event.DirectEvent;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.event.EventRedirector;
import com.sun.javafx.event.EventUtil;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.PopupWindowPeerListener;
import com.sun.javafx.stage.WindowCloseRequestHandler;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public abstract class PopupWindow
extends Window {
    private final List<PopupWindow> children = new ArrayList<PopupWindow>();
    private final InvalidationListener rootBoundsListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            PopupWindow.this.updateDimensions();
        }
    };
    private ReadOnlyObjectWrapper<Window> ownerWindow = new ReadOnlyObjectWrapper(this, "ownerWindow");
    private ReadOnlyObjectWrapper<Node> ownerNode = new ReadOnlyObjectWrapper(this, "ownerNode");
    private BooleanProperty autoFix = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            PopupWindow.this.handleAutofixActivation(PopupWindow.this.isShowing(), this.get());
        }

        @Override
        public Object getBean() {
            return PopupWindow.this;
        }

        @Override
        public String getName() {
            return "autoFix";
        }
    };
    private BooleanProperty autoHide = new SimpleBooleanProperty(this, "autoHide");
    private ObjectProperty<EventHandler<Event>> onAutoHide = new SimpleObjectProperty<EventHandler<Event>>(this, "onAutoHide");
    private BooleanProperty hideOnEscape = new SimpleBooleanProperty(this, "hideOnEscape", true);
    private BooleanProperty consumeAutoHidingEvents = new SimpleBooleanProperty(this, "consumeAutoHidingEvents", true);
    private Window rootWindow;
    private ChangeListener<Boolean> ownerFocusedListener;
    private boolean autofixActive;
    private AutofixHandler autofixHandler;

    public PopupWindow() {
        final Scene scene = new Scene(null);
        scene.setFill(null);
        super.setScene(scene);
        scene.rootProperty().addListener(new InvalidationListener(){
            private Node oldRoot;

            @Override
            public void invalidated(Observable observable) {
                Parent parent = scene.getRoot();
                if (this.oldRoot != parent) {
                    if (this.oldRoot != null) {
                        this.oldRoot.layoutBoundsProperty().removeListener(PopupWindow.this.rootBoundsListener);
                    }
                    if (parent != null) {
                        parent.layoutBoundsProperty().addListener(PopupWindow.this.rootBoundsListener);
                    }
                    this.oldRoot = parent;
                    PopupWindow.this.updateDimensions();
                }
            }
        });
        scene.setRoot(new Group());
    }

    @Deprecated
    protected ObservableList<Node> getContent() {
        Parent parent = this.getScene().getRoot();
        if (!(parent instanceof Group)) {
            throw new IllegalStateException("The content of the Popup can't be accessed");
        }
        return ((Group)parent).getChildren();
    }

    public final Window getOwnerWindow() {
        return (Window)this.ownerWindow.get();
    }

    public final ReadOnlyObjectProperty<Window> ownerWindowProperty() {
        return this.ownerWindow.getReadOnlyProperty();
    }

    public final Node getOwnerNode() {
        return (Node)this.ownerNode.get();
    }

    public final ReadOnlyObjectProperty<Node> ownerNodeProperty() {
        return this.ownerNode.getReadOnlyProperty();
    }

    @Override
    protected final void setScene(Scene scene) {
        throw new UnsupportedOperationException();
    }

    public final void setAutoFix(boolean bl) {
        this.autoFix.set(bl);
    }

    public final boolean isAutoFix() {
        return this.autoFix.get();
    }

    public final BooleanProperty autoFixProperty() {
        return this.autoFix;
    }

    public final void setAutoHide(boolean bl) {
        this.autoHide.set(bl);
    }

    public final boolean isAutoHide() {
        return this.autoHide.get();
    }

    public final BooleanProperty autoHideProperty() {
        return this.autoHide;
    }

    public final void setOnAutoHide(EventHandler<Event> eventHandler) {
        this.onAutoHide.set(eventHandler);
    }

    public final EventHandler<Event> getOnAutoHide() {
        return (EventHandler)this.onAutoHide.get();
    }

    public final ObjectProperty<EventHandler<Event>> onAutoHideProperty() {
        return this.onAutoHide;
    }

    public final void setHideOnEscape(boolean bl) {
        this.hideOnEscape.set(bl);
    }

    public final boolean isHideOnEscape() {
        return this.hideOnEscape.get();
    }

    public final BooleanProperty hideOnEscapeProperty() {
        return this.hideOnEscape;
    }

    public final void setConsumeAutoHidingEvents(boolean bl) {
        this.consumeAutoHidingEvents.set(bl);
    }

    public final boolean getConsumeAutoHidingEvents() {
        return this.consumeAutoHidingEvents.get();
    }

    public final BooleanProperty consumeAutoHidingEventsProperty() {
        return this.consumeAutoHidingEvents;
    }

    public void show(Window window) {
        this.validateOwnerWindow(window);
        this.showImpl(window);
    }

    public void show(Node node, double d, double d2) {
        if (node == null) {
            throw new NullPointerException("The owner node must not be null");
        }
        Scene scene = node.getScene();
        if (scene == null || scene.getWindow() == null) {
            throw new IllegalArgumentException("The owner node needs to be associated with a window");
        }
        Window window = scene.getWindow();
        this.validateOwnerWindow(window);
        this.ownerNode.set(node);
        this.setX(d);
        this.setY(d2);
        this.showImpl(window);
    }

    public void show(Window window, double d, double d2) {
        this.validateOwnerWindow(window);
        this.setX(d);
        this.setY(d2);
        this.showImpl(window);
    }

    private void showImpl(Window window) {
        if (this.isShowing()) {
            if (this.autofixHandler != null) {
                this.autofixHandler.adjustPosition();
            }
            return;
        }
        this.ownerWindow.set(window);
        if (window instanceof PopupWindow) {
            ((PopupWindow)window).children.add(this);
        }
        if (PopupWindow.getRootWindow(window).isShowing()) {
            Parent parent;
            this.show();
            if (!this.isAutoFix() && (parent = this.getScene().getRoot()) != null) {
                Bounds bounds = parent.getLayoutBounds();
                this.setX(this.getX() + bounds.getMinX());
                this.setY(this.getY() + bounds.getMinY());
            }
        }
    }

    @Override
    public void hide() {
        for (PopupWindow popupWindow : this.children) {
            if (!popupWindow.isShowing()) continue;
            popupWindow.hide();
        }
        this.children.clear();
        super.hide();
    }

    @Override
    @Deprecated
    protected void impl_visibleChanging(boolean bl) {
        super.impl_visibleChanging(bl);
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow]");
        Toolkit toolkit = Toolkit.getToolkit();
        if (bl && this.impl_peer == null) {
            this.impl_peer = toolkit.createTKPopupStage(StageStyle.TRANSPARENT, this.getOwnerWindow().impl_getPeer());
            this.peerListener = new PopupWindowPeerListener(this);
        }
    }

    @Override
    @Deprecated
    protected void impl_visibleChanged(boolean bl) {
        super.impl_visibleChanged(bl);
        if (!bl && this.impl_peer != null) {
            this.peerListener = null;
            this.impl_peer = null;
        }
        Window window = this.getOwnerWindow();
        if (bl) {
            this.rootWindow = PopupWindow.getRootWindow(window);
            this.startMonitorOwnerEvents(window);
            this.bindOwnerFocusedProperty(window);
            this.setFocused(window.isFocused());
            this.handleAutofixActivation(true, this.isAutoFix());
            this.rootWindow.increaseFocusGrabCounter();
        } else {
            this.stopMonitorOwnerEvents(window);
            this.unbindOwnerFocusedProperty(window);
            this.setFocused(false);
            this.handleAutofixActivation(false, this.isAutoFix());
            this.rootWindow.decreaseFocusGrabCounter();
            this.rootWindow = null;
        }
        PerformanceTracker.logEvent("PopupWindow.storeVisible for [PopupWindow] finished");
    }

    private void updateDimensions() {
        Parent parent = this.getScene().getRoot();
        if (parent != null) {
            Bounds bounds = parent.getLayoutBounds();
            this.setWidth(bounds.getMaxX() - bounds.getMinX());
            this.setHeight(bounds.getMaxY() - bounds.getMinY());
            parent.setTranslateX(-bounds.getMinX());
            parent.setTranslateY(-bounds.getMinY());
        }
    }

    private static Window getRootWindow(Window window) {
        while (window instanceof PopupWindow) {
            window = ((PopupWindow)window).getOwnerWindow();
        }
        return window;
    }

    void doAutoHide() {
        this.hide();
        if (this.getOnAutoHide() != null) {
            this.getOnAutoHide().handle(new Event(this, this, Event.ANY));
        }
    }

    @Override
    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(new PopupEventRedirector(this), new WindowCloseRequestHandler(this), new EventHandlerManager(this));
    }

    private void startMonitorOwnerEvents(Window window) {
        EventRedirector eventRedirector = window.getInternalEventDispatcher().getEventRedirector();
        eventRedirector.addEventDispatcher(this.getEventDispatcher());
    }

    private void stopMonitorOwnerEvents(Window window) {
        EventRedirector eventRedirector = window.getInternalEventDispatcher().getEventRedirector();
        eventRedirector.removeEventDispatcher(this.getEventDispatcher());
    }

    private void bindOwnerFocusedProperty(Window window) {
        this.ownerFocusedListener = new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                PopupWindow.this.setFocused(bl2);
            }
        };
        window.focusedProperty().addListener(this.ownerFocusedListener);
    }

    private void unbindOwnerFocusedProperty(Window window) {
        window.focusedProperty().removeListener(this.ownerFocusedListener);
        this.ownerFocusedListener = null;
    }

    private void handleAutofixActivation(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = bl3 = bl && bl2;
        if (this.autofixActive != bl3) {
            this.autofixActive = bl3;
            if (bl3) {
                this.autofixHandler = new AutofixHandler();
                this.widthProperty().addListener(this.autofixHandler);
                this.heightProperty().addListener(this.autofixHandler);
                Screen.getScreens().addListener(this.autofixHandler);
                this.autofixHandler.adjustPosition();
            } else {
                this.widthProperty().removeListener(this.autofixHandler);
                this.heightProperty().removeListener(this.autofixHandler);
                Screen.getScreens().removeListener(this.autofixHandler);
                this.autofixHandler = null;
            }
        }
    }

    private void validateOwnerWindow(Window window) {
        if (window == null) {
            throw new NullPointerException("Owner window must not be null");
        }
        if (PopupWindow.wouldCreateCycle(window, this)) {
            throw new IllegalArgumentException("Specified owner window would create cycle in the window hierarchy");
        }
        if (this.isShowing() && this.getOwnerWindow() != window) {
            throw new IllegalStateException("Popup is already shown with different owner window");
        }
    }

    private static Window getOwnerWindow(Window window) {
        if (window instanceof PopupWindow) {
            return ((PopupWindow)window).getOwnerWindow();
        }
        if (window instanceof Stage) {
            return ((Stage)window).getOwner();
        }
        return null;
    }

    private static boolean wouldCreateCycle(Window window, Window window2) {
        while (window != null) {
            if (window == window2) {
                return true;
            }
            window = PopupWindow.getOwnerWindow(window);
        }
        return false;
    }

    private final class AutofixHandler
    implements InvalidationListener {
        private AutofixHandler() {
        }

        @Override
        public void invalidated(Observable observable) {
            this.adjustPosition();
        }

        public void adjustPosition() {
            Screen screen = Utils.getScreenForPoint(PopupWindow.this.getX(), PopupWindow.this.getY());
            Rectangle2D rectangle2D = Utils.hasFullScreenStage(screen) ? screen.getBounds() : screen.getVisualBounds();
            double d = Math.min(PopupWindow.this.getX(), rectangle2D.getMaxX() - PopupWindow.this.getWidth());
            double d2 = Math.min(PopupWindow.this.getY(), rectangle2D.getMaxY() - PopupWindow.this.getHeight());
            d = Math.max(d, rectangle2D.getMinX());
            d2 = Math.max(d2, rectangle2D.getMinY());
            PopupWindow.this.setX(d);
            PopupWindow.this.setY(d2);
        }
    }

    static class PopupEventRedirector
    extends EventRedirector {
        private static final KeyCombination ESCAPE_KEY_COMBINATION = KeyCombination.keyCombination("Esc");
        private final PopupWindow popupWindow;

        public PopupEventRedirector(PopupWindow popupWindow) {
            super(popupWindow);
            this.popupWindow = popupWindow;
        }

        @Override
        protected void handleRedirectedEvent(Object object, Event event) {
            if (event instanceof KeyEvent) {
                this.handleKeyEvent((KeyEvent)event);
                return;
            }
            EventType<? extends Event> eventType = event.getEventType();
            if (eventType == MouseEvent.MOUSE_PRESSED) {
                this.handleMousePressedEvent(object, event);
                return;
            }
            if (eventType == FocusUngrabEvent.FOCUS_UNGRAB) {
                this.handleFocusUngrabEvent();
                return;
            }
        }

        private void handleKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            Scene scene = this.popupWindow.getScene();
            if (scene != null) {
                EventTarget eventTarget;
                Node node = scene.getFocusOwner();
                EventTarget eventTarget2 = eventTarget = node != null ? node : scene;
                if (EventUtil.fireEvent(eventTarget, new DirectEvent(keyEvent)) == null) {
                    keyEvent.consume();
                    return;
                }
            }
            if (keyEvent.getEventType() == KeyEvent.KEY_PRESSED && ESCAPE_KEY_COMBINATION.match(keyEvent)) {
                this.handleEscapeKeyPressedEvent(keyEvent);
            }
        }

        private void handleEscapeKeyPressedEvent(Event event) {
            if (this.popupWindow.isHideOnEscape()) {
                this.popupWindow.doAutoHide();
                if (this.popupWindow.getConsumeAutoHidingEvents()) {
                    event.consume();
                }
            }
        }

        private void handleMousePressedEvent(Object object, Event event) {
            if (this.popupWindow.getOwnerWindow() != object) {
                return;
            }
            if (this.popupWindow.isAutoHide() && !this.isOwnerNodeEvent(event)) {
                Event.fireEvent(this.popupWindow, new FocusUngrabEvent());
                this.popupWindow.doAutoHide();
                if (this.popupWindow.getConsumeAutoHidingEvents()) {
                    event.consume();
                }
            }
        }

        private void handleFocusUngrabEvent() {
            if (this.popupWindow.isAutoHide()) {
                this.popupWindow.doAutoHide();
            }
        }

        private boolean isOwnerNodeEvent(Event event) {
            Node node = this.popupWindow.getOwnerNode();
            if (node == null) {
                return false;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof Node)) {
                return false;
            }
            Node node2 = (Node)eventTarget;
            do {
                if (node2 != node) continue;
                return true;
            } while ((node2 = node2.getParent()) != null);
            return false;
        }
    }
}

