/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.behavior.ChoiceBoxBehavior;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.StringConverter;

public class ChoiceBoxSkin<T>
extends SkinBase<ChoiceBox<T>, ChoiceBoxBehavior<T>> {
    private ObservableList<?> choiceBoxItems;
    private ContextMenu popup;
    private StackPane openButton;
    private final ToggleGroup toggleGroup = new ToggleGroup();
    private SelectionModel selectionModel;
    private Label label;
    private final ListChangeListener choiceBoxItemsListener = new ListChangeListener(){

        public void onChanged(ListChangeListener.Change change) {
            while (change.next()) {
                int n;
                if (change.getRemovedSize() > 0) {
                    ChoiceBoxSkin.this.popup.getItems().clear();
                    n = 0;
                    for (Object e : change.getList()) {
                        ChoiceBoxSkin.this.addPopupItem(e, n);
                        ++n;
                    }
                    ChoiceBoxSkin.this.requestLayout();
                    return;
                }
                for (n = change.getFrom(); n < change.getTo(); ++n) {
                    Iterator iterator = change.getList().get(n);
                    ChoiceBoxSkin.this.addPopupItem(iterator, n);
                }
            }
            ChoiceBoxSkin.this.updateSelection();
            ChoiceBoxSkin.this.popup.getScene().getRoot().impl_processCSS(true);
            ChoiceBoxSkin.this.requestLayout();
        }
    };
    private final WeakListChangeListener weakChoiceBoxItemsListener = new WeakListChangeListener(this.choiceBoxItemsListener);
    private InvalidationListener selectionChangeListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            ChoiceBoxSkin.this.updateSelection();
        }
    };

    public ChoiceBoxSkin(ChoiceBox choiceBox) {
        super(choiceBox, new ChoiceBoxBehavior(choiceBox));
        this.initialize();
        this.requestLayout();
        this.registerChangeListener(choiceBox.selectionModelProperty(), "SELECTION_MODEL");
        this.registerChangeListener(choiceBox.showingProperty(), "SHOWING");
        this.registerChangeListener(choiceBox.itemsProperty(), "ITEMS");
        this.registerChangeListener(choiceBox.getSelectionModel().selectedItemProperty(), "SELECTION_CHANGED");
        this.registerChangeListener(choiceBox.converterProperty(), "CONVERTER");
    }

    private void initialize() {
        this.updateChoiceBoxItems();
        this.label = new Label();
        this.label.setMnemonicParsing(false);
        this.openButton = new StackPane();
        this.openButton.getStyleClass().setAll((String[])new String[]{"open-button"});
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.openButton.getChildren().clear();
        this.openButton.getChildren().addAll((Node[])new Node[]{stackPane});
        this.popup = new ContextMenu();
        this.popup.setOnAutoHide(new EventHandler<Event>(){

            @Override
            public void handle(Event event) {
                ((ChoiceBox)ChoiceBoxSkin.this.getSkinnable()).hide();
            }
        });
        ((ChoiceBox)this.getSkinnable()).focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!bl2.booleanValue()) {
                    ((ChoiceBox)ChoiceBoxSkin.this.getSkinnable()).hide();
                }
            }
        });
        this.popup.setId("choice-box-popup-menu");
        this.getChildren().setAll((Node[])new Node[]{this.label, this.openButton});
        this.updatePopupItems();
        this.updateSelectionModel();
        this.updateSelection();
        if (this.selectionModel != null && this.selectionModel.getSelectedIndex() == -1) {
            this.label.setText("");
        }
    }

    private void updateChoiceBoxItems() {
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.removeListener(this.weakChoiceBoxItemsListener);
        }
        this.choiceBoxItems = ((ChoiceBox)this.getSkinnable()).getItems();
        if (this.choiceBoxItems != null) {
            this.choiceBoxItems.addListener(this.weakChoiceBoxItemsListener);
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("ITEMS".equals(string)) {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
        } else if ("SELECTION_MODEL".equals(string)) {
            this.updateSelectionModel();
        } else if ("SELECTION_CHANGED".equals(string)) {
            MenuItem menuItem;
            int n;
            if (((ChoiceBox)this.getSkinnable()).getSelectionModel() != null && (n = ((ChoiceBox)this.getSkinnable()).getSelectionModel().getSelectedIndex()) != -1 && (menuItem = (MenuItem)this.popup.getItems().get(n)) instanceof RadioMenuItem) {
                ((RadioMenuItem)menuItem).setSelected(true);
            }
        } else if ("SHOWING".equals(string)) {
            if (((ChoiceBox)this.getSkinnable()).isShowing()) {
                ContextMenuContent contextMenuContent;
                boolean bl;
                MenuItem menuItem = null;
                SingleSelectionModel singleSelectionModel = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
                if (singleSelectionModel == null) {
                    return;
                }
                long l = singleSelectionModel.getSelectedIndex();
                int n = this.choiceBoxItems.size();
                boolean bl2 = bl = l >= 0L && l < (long)n;
                if (bl) {
                    menuItem = (MenuItem)this.popup.getItems().get((int)l);
                    if (menuItem != null && menuItem instanceof RadioMenuItem) {
                        ((RadioMenuItem)menuItem).setSelected(true);
                    }
                } else if (n > 0) {
                    menuItem = (MenuItem)this.popup.getItems().get(0);
                }
                ((ChoiceBox)this.getSkinnable()).autosize();
                double d = 0.0;
                if (this.popup.getSkin() != null && (contextMenuContent = (ContextMenuContent)this.popup.getSkin().getNode()) != null && l != -1L) {
                    d = -contextMenuContent.getMenuYOffset((int)l);
                }
                this.popup.show((Node)((Object)this.getSkinnable()), Side.BOTTOM, 0.0, d);
            } else {
                this.popup.hide();
            }
        } else if ("CONVERTER".equals(string)) {
            this.updateChoiceBoxItems();
            this.updatePopupItems();
        }
    }

    private void addPopupItem(Object object, int n) {
        MenuItem menuItem = null;
        if (object instanceof Separator) {
            menuItem = new SeparatorMenuItem();
        } else if (object instanceof SeparatorMenuItem) {
            menuItem = (SeparatorMenuItem)object;
        } else {
            StringConverter<Object> stringConverter = ((ChoiceBox)this.getSkinnable()).getConverter();
            String string = stringConverter == null ? (object == null ? "" : object.toString()) : stringConverter.toString(object);
            final RadioMenuItem radioMenuItem = new RadioMenuItem(string);
            radioMenuItem.setId("choice-box-menu-item");
            radioMenuItem.setToggleGroup(this.toggleGroup);
            final int n2 = n;
            radioMenuItem.setOnAction(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (ChoiceBoxSkin.this.selectionModel == null) {
                        return;
                    }
                    ChoiceBoxSkin.this.selectionModel.select(n2);
                    radioMenuItem.setSelected(true);
                }
            });
            menuItem = radioMenuItem;
        }
        menuItem.setMnemonicParsing(false);
        this.popup.getItems().add(n, menuItem);
    }

    private void updatePopupItems() {
        this.popup.getItems().clear();
        this.toggleGroup.selectToggle(null);
        for (int i = 0; i < this.choiceBoxItems.size(); ++i) {
            Object e = this.choiceBoxItems.get(i);
            this.addPopupItem(e, i);
        }
    }

    private void updateSelectionModel() {
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().removeListener(this.selectionChangeListener);
        }
        this.selectionModel = ((ChoiceBox)this.getSkinnable()).getSelectionModel();
        if (this.selectionModel != null) {
            this.selectionModel.selectedIndexProperty().addListener(this.selectionChangeListener);
        }
    }

    private void updateSelection() {
        if (this.selectionModel == null || this.selectionModel.isEmpty()) {
            this.toggleGroup.selectToggle(null);
            this.label.setText("");
        } else {
            int n = this.selectionModel.getSelectedIndex();
            if (n == -1 || n > this.popup.getItems().size()) {
                this.label.setText("");
                return;
            }
            if (n < this.popup.getItems().size()) {
                MenuItem menuItem = (MenuItem)this.popup.getItems().get(n);
                if (menuItem instanceof RadioMenuItem) {
                    ((RadioMenuItem)menuItem).setSelected(true);
                    this.toggleGroup.selectToggle(null);
                }
                this.label.setText(((MenuItem)this.popup.getItems().get(n)).getText());
            }
        }
    }

    @Override
    protected void layoutChildren() {
        double d = this.openButton.prefWidth(-1.0);
        double d2 = ((ChoiceBox)this.getSkinnable()).getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        double d3 = ((ChoiceBox)this.getSkinnable()).getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight() + d);
        this.label.resizeRelocate(this.getInsets().getLeft(), this.getInsets().getTop(), d3, d2);
        this.openButton.resize(d, this.openButton.prefHeight(-1.0));
        this.positionInArea(this.openButton, this.getWidth() - this.getInsets().getRight() - d, this.getInsets().getTop(), d, d2, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d) {
        double d2 = this.label.minWidth(-1.0) + this.openButton.minWidth(-1.0);
        double d3 = this.popup.minWidth(-1.0);
        return this.getInsets().getLeft() + Math.max(d2, d3) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        double d2 = this.label.minHeight(-1.0);
        double d3 = this.openButton.minHeight(-1.0);
        return this.getInsets().getTop() + Math.max(d2, d3) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.label.prefWidth(-1.0) + this.openButton.prefWidth(-1.0);
        double d3 = this.popup.prefWidth(-1.0);
        if (d3 <= 0.0 && this.popup.getItems().size() > 0) {
            d3 = new Text(((MenuItem)this.popup.getItems().get(0)).getText()).prefWidth(-1.0);
        }
        return this.popup.getItems().size() == 0 ? 50.0 : this.getInsets().getLeft() + Math.max(d2, d3) + this.getInsets().getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.label.prefHeight(-1.0);
        double d3 = this.openButton.prefHeight(-1.0);
        return this.getInsets().getTop() + Math.max(d2, d3) + this.getInsets().getBottom();
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((ChoiceBox)this.getSkinnable()).prefHeight(d);
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((ChoiceBox)this.getSkinnable()).prefWidth(d);
    }
}

