/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.border.MatteBorder;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaDefaults;
import processing.app.syntax.TextAreaPainter;
import processing.app.syntax.TokenMarker;

public class TextAreaLineNumbers
extends TextAreaPainter {
    private final int LEFT_INDENT = 6;
    private final int RIGHT_INDENT = 6;
    private final int RIGHT_BORDER_WIDTH = 1;
    private final int PADDING_WIDTH = 13;
    private final int MIN_WIDTH;
    private final int DIGIT_WIDTH = this.getFontMetrics(this.getFont()).stringWidth("0");
    private final int MIN_NUM_DIGITS = 2;
    private int currStartNum = 0;
    private int currEndNum = 0;
    private int currNumDigits = 2;

    public TextAreaLineNumbers(JEditTextArea textArea, TextAreaDefaults defaults) {
        super(textArea, defaults);
        this.MIN_WIDTH = this.DIGIT_WIDTH * 2 + 13;
        this.setEnabled(false);
        this.setBorder(new MatteBorder(0, 0, 0, 1, new Color(240, 240, 240)));
    }

    public void updateLineNumbers(int startNum, int endNum) {
        if (this.currStartNum == startNum && this.currEndNum == endNum) {
            return;
        }
        this.currStartNum = startNum;
        this.currEndNum = endNum;
        this.invalidate();
        this.repaint();
    }

    @Override
    public void paint(Graphics gfx) {
        super.paint(gfx);
        this.getBorder().paintBorder(this, gfx, 0, 0, this.getSize().width, this.getSize().height);
    }

    @Override
    protected void paintLine(Graphics gfx, TokenMarker tokenMarker, int line, int x) {
        this.currentLineIndex = line;
        gfx.setFont(this.getFont());
        gfx.setColor(Color.GRAY);
        int y = this.textArea.lineToY(line);
        int startX = this.getBounds().x + this.getBounds().width;
        if (line >= 0 && line < this.textArea.getLineCount()) {
            String lineNumberString = String.valueOf(line + 1);
            int lineStartX = startX - 1 - 6 - this.fm.stringWidth(lineNumberString);
            gfx.drawString(lineNumberString, lineStartX, y + this.fm.getHeight());
        }
    }

    public void updateWidthForNumDigits(int numDigits) {
        if (this.currNumDigits == numDigits) {
            return;
        }
        this.currNumDigits = numDigits;
        if (this.isVisible()) {
            this.updateBounds();
            this.invalidate();
            this.repaint();
        }
    }

    public void setDisplayLineNumbers(boolean displayLineNumbers) {
        this.setVisible(displayLineNumbers);
        if (displayLineNumbers) {
            this.updateBounds();
        } else {
            this.setBounds(new Rectangle(0, this.getHeight()));
        }
        this.invalidate();
        this.repaint();
    }

    private void updateBounds() {
        if (this.isVisible()) {
            this.setBounds(new Rectangle(Math.max(this.MIN_WIDTH, this.DIGIT_WIDTH * this.currNumDigits + 13), this.getHeight()));
            this.textArea.validate();
        }
    }
}

