/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.Theme;

public class EditorToolbar
extends JComponent
implements MouseInputListener,
KeyListener {
    static final String[] title = new String[]{I18n._((String)"Verify"), I18n._((String)"Upload"), I18n._((String)"New"), I18n._((String)"Open"), I18n._((String)"Save"), I18n._((String)"Serial Monitor")};
    static final String[] titleShift = new String[]{I18n._((String)"Verify"), I18n._((String)"Upload Using Programmer"), I18n._((String)"New Editor Window"), I18n._((String)"Open in Another Window"), I18n._((String)"Save"), I18n._((String)"Serial Monitor")};
    static final int BUTTON_COUNT = title.length;
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final int BUTTON_GAP = 5;
    static final int BUTTON_IMAGE_SIZE = 33;
    static final int RUN = 0;
    static final int EXPORT = 1;
    static final int NEW = 2;
    static final int OPEN = 3;
    static final int SAVE = 4;
    static final int SERIAL = 5;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    Editor editor;
    Image offscreen;
    int width;
    int height;
    Color bgcolor;
    static Image[][] buttonImages;
    int currentRollover;
    JPopupMenu popup;
    JMenu menu;
    int buttonCount;
    int[] state = new int[BUTTON_COUNT];
    Image[] stateImage;
    int[] which;
    int[] x1;
    int[] x2;
    int y1;
    int y2;
    Font statusFont;
    Color statusColor;
    boolean shiftPressed;
    int wasDown = -1;

    public EditorToolbar(Editor editor, JMenu menu) {
        this.editor = editor;
        this.menu = menu;
        this.buttonCount = 0;
        this.which = new int[BUTTON_COUNT];
        this.which[this.buttonCount++] = 0;
        this.which[this.buttonCount++] = 1;
        this.which[this.buttonCount++] = 2;
        this.which[this.buttonCount++] = 3;
        this.which[this.buttonCount++] = 4;
        this.which[this.buttonCount++] = 5;
        this.currentRollover = -1;
        this.bgcolor = Theme.getColor("buttons.bgcolor");
        this.statusFont = Theme.getFont("buttons.status.font");
        this.statusColor = Theme.getColor("buttons.status.color");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void loadButtons() {
        Image allButtons = Base.getThemeImage("buttons.gif", this);
        buttonImages = new Image[BUTTON_COUNT][3];
        for (int i = 0; i < BUTTON_COUNT; ++i) {
            for (int state = 0; state < 3; ++state) {
                Image image = this.createImage(27, 32);
                Graphics g = image.getGraphics();
                g.drawImage(allButtons, -(i * 33) - 3, (-2 + state) * 33, null);
                EditorToolbar.buttonImages[i][state] = image;
            }
        }
    }

    @Override
    public void paintComponent(Graphics screen) {
        int i;
        if (buttonImages == null) {
            this.loadButtons();
        }
        if (this.stateImage == null) {
            this.state = new int[this.buttonCount];
            this.stateImage = new Image[this.buttonCount];
            for (int i2 = 0; i2 < this.buttonCount; ++i2) {
                this.setState(i2, 0, false);
            }
            this.y1 = 0;
            this.y2 = 32;
            this.x1 = new int[this.buttonCount];
            this.x2 = new int[this.buttonCount];
        }
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.width || size.height != this.height) {
            this.offscreen = this.createImage(size.width, size.height);
            this.width = size.width;
            this.height = size.height;
            int offsetX = 3;
            for (i = 0; i < this.buttonCount; ++i) {
                this.x1[i] = offsetX;
                if (i == 2 || i == 6) {
                    int n = i;
                    this.x1[n] = this.x1[n] + 5;
                }
                this.x2[i] = this.x1[i] + 27;
                offsetX = this.x2[i];
            }
            this.x1[5] = this.width - 27 - 14;
            this.x2[5] = this.width - 14;
        }
        Graphics g = this.offscreen.getGraphics();
        g.setColor(this.bgcolor);
        g.fillRect(0, 0, this.width, this.height);
        for (i = 0; i < this.buttonCount; ++i) {
            g.drawImage(this.stateImage[i], this.x1[i], this.y1, null);
        }
        g.setColor(this.statusColor);
        g.setFont(this.statusFont);
        if (this.currentRollover != -1) {
            String status;
            int statusY = (32 + g.getFontMetrics().getAscent()) / 2;
            String string = status = this.shiftPressed ? titleShift[this.currentRollover] : title[this.currentRollover];
            if (this.currentRollover != 5) {
                g.drawString(status, (this.buttonCount - 1) * 27 + 15, statusY);
            } else {
                int statusX = this.x1[5] - 5;
                g.drawString(status, statusX -= g.getFontMetrics().stringWidth(status), statusY);
            }
        }
        screen.drawImage(this.offscreen, 0, 0, null);
        if (!this.isEnabled()) {
            screen.setColor(new Color(0, 0, 0, 100));
            screen.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.state == null) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, false);
        }
        this.handleMouse(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void handleMouse(MouseEvent e) {
        int sel;
        int x = e.getX();
        int y = e.getY();
        if (this.currentRollover != -1) {
            if (x > this.x1[this.currentRollover] && y > this.y1 && x < this.x2[this.currentRollover] && y < this.y2) {
                return;
            }
            this.setState(this.currentRollover, 0, true);
            this.currentRollover = -1;
        }
        if ((sel = this.findSelection(x, y)) == -1) {
            return;
        }
        if (this.state[sel] != 2) {
            this.setState(sel, 1, true);
            this.currentRollover = sel;
        }
    }

    private int findSelection(int x, int y) {
        if (this.x1 == null || this.x2 == null) {
            return -1;
        }
        for (int i = 0; i < this.buttonCount; ++i) {
            if (y <= this.y1 || x <= this.x1[i] || y >= this.y2 || x >= this.x2[i]) continue;
            return i;
        }
        return -1;
    }

    private void setState(int slot, int newState, boolean updateAfter) {
        this.state[slot] = newState;
        this.stateImage[slot] = buttonImages[this.which[slot]][newState];
        if (updateAfter) {
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.handleMouse(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, true);
        }
        this.handleMouse(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int y;
        if (!this.isEnabled()) {
            return;
        }
        int x = e.getX();
        int sel = this.findSelection(x, y = e.getY());
        if (sel == -1) {
            return;
        }
        this.currentRollover = -1;
        switch (sel) {
            case 0: {
                this.editor.handleRun(false);
                break;
            }
            case 3: {
                this.popup = this.menu.getPopupMenu();
                this.popup.show(this, x, y);
                break;
            }
            case 2: {
                if (this.shiftPressed) {
                    try {
                        this.editor.base.handleNew();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                this.editor.base.handleNewReplace();
                break;
            }
            case 4: {
                this.editor.handleSave(false);
                break;
            }
            case 1: {
                this.editor.handleExport(e.isShiftDown());
                break;
            }
            case 5: {
                this.editor.handleSerial();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void activate(int what) {
        if (buttonImages != null) {
            this.setState(what, 2, true);
        }
    }

    public void deactivate(int what) {
        if (buttonImages != null) {
            this.setState(what, 0, true);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension((BUTTON_COUNT + 1) * 27, 32);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = true;
            this.repaint();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = false;
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

