/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import processing.app.syntax.JEditTextArea;

public class CaretAwareUndoableEdit
implements UndoableEdit {
    private final UndoableEdit undoableEdit;
    private final int caretPosition;

    public CaretAwareUndoableEdit(UndoableEdit undoableEdit, JEditTextArea textArea) {
        this.undoableEdit = undoableEdit;
        this.caretPosition = textArea.getCaretPosition();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.undoableEdit.undo();
    }

    @Override
    public boolean canUndo() {
        return this.undoableEdit.canUndo();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.undoableEdit.redo();
    }

    @Override
    public boolean canRedo() {
        return this.undoableEdit.canRedo();
    }

    @Override
    public void die() {
        this.undoableEdit.die();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        return this.undoableEdit.addEdit(undoableEdit);
    }

    @Override
    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return this.undoableEdit.replaceEdit(undoableEdit);
    }

    @Override
    public boolean isSignificant() {
        return this.undoableEdit.isSignificant();
    }

    @Override
    public String getPresentationName() {
        return this.undoableEdit.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        return this.undoableEdit.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        return this.undoableEdit.getRedoPresentationName();
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }
}

