/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;
import processing.app.SerialPortList;

public class Serial
implements SerialPortEventListener {
    SerialPort port;
    int rate;
    int parity;
    int databits;
    int stopbits;

    public Serial() throws SerialException {
        this(PreferencesData.get("serial.port"), PreferencesData.getInteger("serial.debug_rate"), PreferencesData.get("serial.parity").charAt(0), PreferencesData.getInteger("serial.databits"), new Float(PreferencesData.get("serial.stopbits")).floatValue());
    }

    public Serial(int n) throws SerialException {
        this(PreferencesData.get("serial.port"), n, PreferencesData.get("serial.parity").charAt(0), PreferencesData.getInteger("serial.databits"), new Float(PreferencesData.get("serial.stopbits")).floatValue());
    }

    public Serial(String string, int n) throws SerialException {
        this(string, n, PreferencesData.get("serial.parity").charAt(0), PreferencesData.getInteger("serial.databits"), new Float(PreferencesData.get("serial.stopbits")).floatValue());
    }

    public Serial(String string) throws SerialException {
        this(string, PreferencesData.getInteger("serial.debug_rate"), PreferencesData.get("serial.parity").charAt(0), PreferencesData.getInteger("serial.databits"), new Float(PreferencesData.get("serial.stopbits")).floatValue());
    }

    public static boolean touchPort(String string, int n) throws SerialException {
        SerialPort serialPort = new SerialPort(string);
        try {
            serialPort.openPort();
            serialPort.setParams(n, 8, 1, 0);
            serialPort.closePort();
            boolean bl = true;
            return bl;
        }
        catch (SerialPortException serialPortException) {
            throw new SerialException(I18n.format(I18n._("Error touching serial port ''{0}''."), string), serialPortException);
        }
        finally {
            if (serialPort.isOpened()) {
                try {
                    serialPort.closePort();
                }
                catch (SerialPortException serialPortException) {}
            }
        }
    }

    public Serial(String string, int n, char c, int n2, float f) throws SerialException {
        this.rate = n;
        this.parity = 0;
        if (c == 'E') {
            this.parity = 2;
        }
        if (c == 'O') {
            this.parity = 1;
        }
        this.databits = n2;
        this.stopbits = 1;
        if (f == 1.5f) {
            this.stopbits = 3;
        }
        if (f == 2.0f) {
            this.stopbits = 2;
        }
        try {
            this.port = new SerialPort(string);
            this.port.openPort();
            this.port.setParams(this.rate, this.databits, this.stopbits, this.parity, true, true);
            this.port.addEventListener((SerialPortEventListener)this);
        }
        catch (Exception exception) {
            throw new SerialException(I18n.format(I18n._("Error opening serial port ''{0}''."), string), exception);
        }
        if (this.port == null) {
            throw new SerialNotFoundException(I18n.format(I18n._("Serial port ''{0}'' not found. Did you select the right one from the Tools > Serial Port menu?"), string));
        }
    }

    public void setup() {
    }

    public void dispose() throws IOException {
        if (this.port != null) {
            try {
                if (this.port.isOpened()) {
                    this.port.closePort();
                }
            }
            catch (SerialPortException serialPortException) {
                throw new IOException(serialPortException);
            }
            finally {
                this.port = null;
            }
        }
    }

    public synchronized void serialEvent(SerialPortEvent serialPortEvent) {
        if (serialPortEvent.isRXCHAR()) {
            try {
                byte[] byArray = this.port.readBytes(serialPortEvent.getEventValue());
                if (byArray.length > 0) {
                    String string = new String(byArray);
                    char[] cArray = string.toCharArray();
                    this.message(cArray, cArray.length);
                }
            }
            catch (SerialPortException serialPortException) {
                Serial.errorMessage("serialEvent", serialPortException);
            }
        }
    }

    protected void message(char[] cArray, int n) {
    }

    public void write(int n) {
        try {
            this.port.writeInt(n & 0xFF);
        }
        catch (SerialPortException serialPortException) {
            Serial.errorMessage("write", serialPortException);
        }
    }

    public void write(byte[] byArray) {
        try {
            this.port.writeBytes(byArray);
        }
        catch (SerialPortException serialPortException) {
            Serial.errorMessage("write", serialPortException);
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public void setDTR(boolean bl) {
        try {
            this.port.setDTR(bl);
        }
        catch (SerialPortException serialPortException) {
            Serial.errorMessage("setDTR", serialPortException);
        }
    }

    public void setRTS(boolean bl) {
        try {
            this.port.setRTS(bl);
        }
        catch (SerialPortException serialPortException) {
            Serial.errorMessage("setRTS", serialPortException);
        }
    }

    public static List<String> list() {
        return Arrays.asList(SerialPortList.getPortNames());
    }

    public static void errorMessage(String string, Throwable throwable) {
        System.err.println(I18n.format(I18n._("Error inside Serial.{0}()"), string));
        throwable.printStackTrace();
    }
}

