/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ResourceBundle i18n;
    static String PROMPT_YES;
    static String PROMPT_NO;
    static String PROMPT_CANCEL;
    static String PROMPT_OK;
    static String PROMPT_BROWSE;

    protected static void init(String string) throws MissingResourceException {
        String[] stringArray = string.split("_");
        Locale locale = Locale.getDefault();
        if (stringArray.length == 2) {
            locale = new Locale(stringArray[0], stringArray[1]);
        } else if (stringArray.length == 1 && !"".equals(stringArray[0])) {
            locale = new Locale(stringArray[0]);
        }
        Locale.setDefault(locale);
        i18n = ResourceBundle.getBundle("processing.app.i18n.Resources", Locale.getDefault());
        PROMPT_YES = I18n._("Yes");
        PROMPT_NO = I18n._("No");
        PROMPT_CANCEL = I18n._("Cancel");
        PROMPT_OK = I18n._("OK");
        PROMPT_BROWSE = I18n._("Browse");
    }

    public static String _(String string) {
        String string2;
        try {
            string2 = i18n == null ? string : i18n.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        string2 = string2.replace("%%", "%");
        return string2;
    }

    public static String format(String string, Object ... objectArray) {
        string = string.replace("''", "'");
        string = string.replace("'", "''");
        return MessageFormat.format(string, objectArray);
    }

    protected static void unusedStrings() {
        I18n._("Arduino AVR Boards");
        I18n._("Arduino ARM (32-bits) Boards");
        I18n._("Processor");
    }
}

