/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.packages.DiscoveryManager;
import cc.arduino.packages.Uploader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.impl.NoOpLog;
import processing.app.I18n;
import processing.app.Platform;
import processing.app.PreferencesData;
import processing.app.SketchData;
import processing.app.debug.Compiler;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.BasicUserNotifier;
import processing.app.helpers.CommandlineParser;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.UserNotifier;
import processing.app.helpers.filefilters.OnlyDirs;
import processing.app.helpers.filefilters.OnlyFilesWithExtension;
import processing.app.legacy.PApplet;
import processing.app.packages.Library;
import processing.app.packages.LibraryList;

public class BaseNoGui {
    public static final int REVISION = 10600;
    static String VERSION_NAME = "1.6.0";
    static File buildFolder;
    static String currentDirectory;
    private static DiscoveryManager discoveryManager;
    private static File examplesFolder;
    private static File toolsFolder;
    public static Map<String, Library> importToLibraryTable;
    private static LibraryList libraries;
    private static List<File> librariesFolders;
    static UserNotifier notifier;
    public static Map<String, TargetPackage> packages;
    static Platform platform;
    static File portableFolder;
    static final String portableSketchbookFolder = "sketchbook";

    public static File absoluteFile(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(currentDirectory, string);
        }
        return file;
    }

    public static int countLines(String string) {
        int n = 1;
        for (char c : string.toCharArray()) {
            if (c != '\n') continue;
            ++n;
        }
        return n;
    }

    public static File createTempFolder(String string) {
        try {
            File file = File.createTempFile(string, null);
            file.delete();
            file.mkdirs();
            return file;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static String getAvrBasePath() {
        String string = BaseNoGui.getHardwarePath() + File.separator + "tools" + File.separator + "avr" + File.separator + "bin" + File.separator;
        if (OSUtils.isLinux() && !new File(string).exists()) {
            return "";
        }
        return string;
    }

    public static File getBuildFolder() {
        if (buildFolder == null) {
            String string = PreferencesData.get("build.path");
            if (string != null) {
                buildFolder = BaseNoGui.absoluteFile(string);
                if (!buildFolder.exists()) {
                    buildFolder.mkdirs();
                }
            } else {
                buildFolder = BaseNoGui.createTempFolder("build");
                buildFolder.deleteOnExit();
            }
        }
        return buildFolder;
    }

    public static PreferencesMap getBoardPreferences() {
        TargetBoard targetBoard = BaseNoGui.getTargetBoard();
        if (targetBoard == null) {
            return null;
        }
        PreferencesMap preferencesMap = new PreferencesMap(targetBoard.getPreferences());
        for (String string : targetBoard.getMenuIds()) {
            String string2 = PreferencesData.get("custom_" + string);
            if (!targetBoard.hasMenu(string) || string2 == null || !string2.startsWith(targetBoard.getId())) continue;
            String string3 = string2.substring(string2.indexOf("_") + 1);
            preferencesMap.putAll(targetBoard.getMenuPreferences(string, string3));
            preferencesMap.put("name", (String)preferencesMap.get("name") + ", " + targetBoard.getMenuLabel(string, string3));
        }
        return preferencesMap;
    }

    public static File getContentFile(String string) {
        File file = new File(System.getProperty("user.dir"));
        if (OSUtils.isMacOS()) {
            if (System.getProperty("WORK_DIR") != null) {
                file = new File(System.getProperty("WORK_DIR"));
            } else {
                try {
                    file = new File(BaseNoGui.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile();
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new RuntimeException(uRISyntaxException);
                }
            }
        }
        return new File(file, string);
    }

    public static TargetPlatform getCurrentTargetPlatformFromPackage(String string) {
        return BaseNoGui.getTargetPlatform(string, PreferencesData.get("target_platform"));
    }

    public static File getDefaultSketchbookFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return new File(BaseNoGui.getPortableFolder(), BaseNoGui.getPortableSketchbookFolder());
        }
        File file = null;
        try {
            file = BaseNoGui.getPlatform().getDefaultSketchbookFolder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    public static DiscoveryManager getDiscoveryManager() {
        return discoveryManager;
    }

    public static File getExamplesFolder() {
        return examplesFolder;
    }

    public static String getExamplesPath() {
        return examplesFolder.getAbsolutePath();
    }

    public static File getHardwareFolder() {
        return BaseNoGui.getContentFile("hardware");
    }

    public static String getHardwarePath() {
        return BaseNoGui.getHardwareFolder().getAbsolutePath();
    }

    public static LibraryList getLibraries() {
        return libraries;
    }

    public static List<File> getLibrariesPath() {
        return librariesFolders;
    }

    public static InputStream getLibStream(String string) throws IOException {
        return new FileInputStream(new File(BaseNoGui.getContentFile("lib"), string));
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static File getPortableFolder() {
        return portableFolder;
    }

    public static String getPortableSketchbookFolder() {
        return portableSketchbookFolder;
    }

    public static File getSettingsFile(String string) {
        return new File(BaseNoGui.getSettingsFolder(), string);
    }

    public static File getSettingsFolder() {
        if (BaseNoGui.getPortableFolder() != null) {
            return BaseNoGui.getPortableFolder();
        }
        File file = null;
        String string = PreferencesData.get("settings.path");
        if (string != null) {
            file = BaseNoGui.absoluteFile(string);
        } else {
            try {
                file = BaseNoGui.getPlatform().getSettingsFolder();
            }
            catch (Exception exception) {
                BaseNoGui.showError(I18n._("Problem getting data folder"), I18n._("Error getting the Arduino data folder."), exception);
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            BaseNoGui.showError(I18n._("Settings issues"), I18n._("Arduino cannot run because it could not\ncreate a folder to store your settings."), null);
        }
        return file;
    }

    public static File getSketchbookFolder() {
        if (portableFolder != null) {
            return new File(portableFolder, PreferencesData.get("sketchbook.path"));
        }
        return BaseNoGui.absoluteFile(PreferencesData.get("sketchbook.path"));
    }

    public static File getSketchbookHardwareFolder() {
        return new File(BaseNoGui.getSketchbookFolder(), "hardware");
    }

    public static File getSketchbookLibrariesFolder() {
        File file = new File(BaseNoGui.getSketchbookFolder(), "libraries");
        if (!file.exists()) {
            try {
                file.mkdirs();
                File file2 = new File(file, "readme.txt");
                FileWriter fileWriter = new FileWriter(file2);
                fileWriter.write(I18n._("For information on installing libraries, see: http://arduino.cc/en/Guide/Libraries\n"));
                fileWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public static String getSketchbookPath() {
        File file;
        String string = PreferencesData.get("sketchbook.path");
        if (string != null && !(file = BaseNoGui.getPortableFolder() != null ? new File(BaseNoGui.getPortableFolder(), string) : BaseNoGui.absoluteFile(string)).exists()) {
            BaseNoGui.showWarning(I18n._("Sketchbook folder disappeared"), I18n._("The sketchbook folder no longer exists.\nArduino will switch to the default sketchbook\nlocation, and create a new sketchbook folder if\nnecessary. Arduino will then stop talking about\nhimself in the third person."), null);
            string = null;
        }
        return string;
    }

    public static TargetBoard getTargetBoard() {
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform == null) {
            return null;
        }
        String string = PreferencesData.get("board");
        return targetPlatform.getBoard(string);
    }

    public static TargetPackage getTargetPackage(String string) {
        return packages.get(string);
    }

    public static TargetPlatform getTargetPlatform() {
        String string = PreferencesData.get("target_package");
        String string2 = PreferencesData.get("target_platform");
        return BaseNoGui.getTargetPlatform(string, string2);
    }

    public static TargetPlatform getTargetPlatform(String string, String string2) {
        TargetPackage targetPackage = packages.get(string);
        if (targetPackage == null) {
            return null;
        }
        return targetPackage.get(string2);
    }

    public static File getToolsFolder() {
        return toolsFolder;
    }

    public static String getToolsPath() {
        return toolsFolder.getAbsolutePath();
    }

    public static LibraryList getUserLibs() {
        if (libraries == null) {
            return new LibraryList();
        }
        return libraries.filterLibrariesInSubfolder(BaseNoGui.getSketchbookFolder());
    }

    public static String[] headerListFromIncludePath(File file) throws IOException {
        String[] stringArray = file.list(new OnlyFilesWithExtension(".h"));
        if (stringArray == null) {
            throw new IOException();
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String[] stringArray) {
        Object object;
        Object object2;
        Iterator iterator;
        BaseNoGui.getPlatform().init();
        String string = BaseNoGui.getSketchbookPath();
        if (string == null) {
            if (BaseNoGui.getPortableFolder() != null) {
                PreferencesData.set("sketchbook.path", BaseNoGui.getPortableSketchbookFolder());
            } else {
                BaseNoGui.showError(I18n._("No sketchbook"), I18n._("Sketchbook path not defined"), null);
            }
        }
        BaseNoGui.initPackages();
        BaseNoGui.onBoardOrPortChange();
        CommandlineParser commandlineParser = CommandlineParser.newCommandlineParser(stringArray);
        for (String string2 : commandlineParser.getFilenames()) {
            iterator = BaseNoGui.absoluteFile(string2);
            if (OSUtils.isWindows()) {
                try {
                    iterator = ((File)((Object)iterator)).getCanonicalFile();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!commandlineParser.isVerifyOrUploadMode() && !commandlineParser.isGetPrefMode()) {
                BaseNoGui.showError(I18n._("Mode not supported"), I18n._("Only --verify, --upload or --get-pref are supported"), null);
            }
            if (!commandlineParser.isForceSavePrefs()) {
                PreferencesData.setDoSave(false);
            }
            if (((File)((Object)iterator)).exists()) continue;
            object2 = I18n.format(I18n._("Failed to open sketch: \"{0}\""), string2);
            BaseNoGui.showError(null, (String)object2, 2);
        }
        PreferencesData.save();
        if (commandlineParser.isVerifyOrUploadMode()) {
            PreferencesData.set("build.verbose", "" + commandlineParser.isDoVerboseBuild());
            PreferencesData.set("upload.verbose", "" + commandlineParser.isDoVerboseUpload());
            PreferencesData.setDoSave(false);
            if (commandlineParser.isUploadMode()) {
                if (commandlineParser.getFilenames().size() != 1) {
                    BaseNoGui.showError(I18n._("Multiple files not supported"), I18n._("The --upload option supports only one file at a time"), null);
                }
                object = new LinkedList();
                boolean bl = false;
                try {
                    String string3;
                    iterator = new SketchData(BaseNoGui.absoluteFile(commandlineParser.getFilenames().get(0)));
                    object2 = BaseNoGui.getBuildFolder();
                    ((SketchData)((Object)iterator)).load();
                    if (!((SketchData)((Object)iterator)).getFolder().exists()) {
                        BaseNoGui.showError(I18n._("No sketch"), I18n._("Can't find the sketch in the specified path"), null);
                    }
                    if ((string3 = Compiler.build(iterator, ((File)object2).getAbsolutePath(), (File)object2, null, commandlineParser.isDoVerboseBuild())) == null) {
                        BaseNoGui.showError(I18n._("Error while verifying"), I18n._("An error occurred while verifying the sketch"), null);
                    }
                    BaseNoGui.showMessage(I18n._("Done compiling"), I18n._("Done compiling"));
                    Uploader uploader = Compiler.getUploaderByPreferences(commandlineParser.isNoUploadPort());
                    if (uploader.requiresAuthorization() && !PreferencesData.has(uploader.getAuthorizationKey())) {
                        BaseNoGui.showError("...", "...", null);
                    }
                    try {
                        bl = Compiler.upload(iterator, uploader, ((File)object2).getAbsolutePath(), string3, commandlineParser.isDoUseProgrammer(), commandlineParser.isNoUploadPort(), (List<String>)object);
                        BaseNoGui.showMessage(I18n._("Done uploading"), I18n._("Done uploading"));
                    }
                    finally {
                        if (uploader.requiresAuthorization() && !bl) {
                            PreferencesData.remove(uploader.getAuthorizationKey());
                        }
                    }
                }
                catch (Exception exception) {
                    BaseNoGui.showError(I18n._("Error while verifying/uploading"), I18n._("An error occurred while verifying/uploading the sketch"), exception);
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object2 = (String)iterator.next();
                    System.out.print(I18n._("Warning"));
                    System.out.print(": ");
                    System.out.println((String)object2);
                }
                if (!bl) {
                    BaseNoGui.showError(I18n._("Error while uploading"), I18n._("An error occurred while uploading the sketch"), null);
                }
            } else {
                for (String string2 : commandlineParser.getFilenames()) {
                    try {
                        String string4;
                        iterator = new SketchData(BaseNoGui.absoluteFile(string2));
                        object2 = BaseNoGui.getBuildFolder();
                        ((SketchData)((Object)iterator)).load();
                        if (!((SketchData)((Object)iterator)).getFolder().exists()) {
                            BaseNoGui.showError(I18n._("No sketch"), I18n._("Can't find the sketch in the specified path"), null);
                        }
                        if ((string4 = Compiler.build(iterator, ((File)object2).getAbsolutePath(), (File)object2, null, commandlineParser.isDoVerboseBuild())) == null) {
                            BaseNoGui.showError(I18n._("Error while verifying"), I18n._("An error occurred while verifying the sketch"), null);
                        }
                        BaseNoGui.showMessage(I18n._("Done compiling"), I18n._("Done compiling"));
                    }
                    catch (Exception exception) {
                        BaseNoGui.showError(I18n._("Error while verifying"), I18n._("An error occurred while verifying the sketch"), exception);
                    }
                }
            }
            System.exit(0);
        } else if (commandlineParser.isGetPrefMode()) {
            object = PreferencesData.get(commandlineParser.getGetPref(), null);
            if (object != null) {
                System.out.println((String)object);
                System.exit(0);
            } else {
                System.exit(4);
            }
        }
    }

    public static void initLogger() {
        System.setProperty("org.apache.commons.logging.Log", NoOpLog.class.getCanonicalName());
        Logger.getLogger("javax.jmdns").setLevel(Level.OFF);
    }

    public static void initPackages() {
        packages = new HashMap<String, TargetPackage>();
        BaseNoGui.loadHardware(BaseNoGui.getHardwareFolder());
        BaseNoGui.loadHardware(BaseNoGui.getSketchbookHardwareFolder());
        if (packages.size() == 0) {
            System.out.println(I18n._("No valid configured cores found! Exiting..."));
            System.exit(3);
        }
    }

    protected static void initPlatform() {
        try {
            Class<?> clazz = Class.forName("processing.app.Platform");
            if (OSUtils.isMacOS()) {
                clazz = Class.forName("processing.app.macosx.Platform");
            } else if (OSUtils.isWindows()) {
                clazz = Class.forName("processing.app.windows.Platform");
            } else if (OSUtils.isLinux()) {
                clazz = Class.forName("processing.app.linux.Platform");
            }
            platform = (Platform)clazz.newInstance();
        }
        catch (Exception exception) {
            BaseNoGui.showError(I18n._("Problem Setting the Platform"), I18n._("An unknown error occurred while trying to load\nplatform-specific code for your machine."), exception);
        }
    }

    public static void initPortableFolder() {
        portableFolder = BaseNoGui.getContentFile("portable");
        if (!portableFolder.exists()) {
            portableFolder = null;
        }
    }

    public static void initVersion() {
        PreferencesData.set("last.ide." + VERSION_NAME + ".hardwarepath", BaseNoGui.getHardwarePath());
        PreferencesData.set("last.ide." + VERSION_NAME + ".daterun", "" + new Date().getTime() / 1000L);
    }

    public static boolean isSanitaryName(String string) {
        return BaseNoGui.sanitizeName(string).equals(string);
    }

    protected static void loadHardware(File file) {
        if (!file.isDirectory()) {
            return;
        }
        String[] stringArray = file.list(new OnlyDirs());
        if (stringArray == null) {
            return;
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        for (String string : stringArray) {
            if (string.equals("tools")) continue;
            File file2 = new File(file, string);
            try {
                packages.put(string, new TargetPackage(string, file2));
            }
            catch (TargetPlatformException targetPlatformException) {
                System.out.println("WARNING: Error loading hardware folder " + string);
                System.out.println("  " + targetPlatformException.getMessage());
            }
        }
    }

    public static String loadFile(File file) throws IOException {
        String[] stringArray = PApplet.loadStrings(file);
        if (stringArray == null) {
            return null;
        }
        return PApplet.join(stringArray, "\n");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            BaseNoGui.showError(I18n._("No parameters"), I18n._("No command line parameters found"), null);
        }
        BaseNoGui.initPlatform();
        BaseNoGui.initPortableFolder();
        BaseNoGui.initParameters(stringArray);
        BaseNoGui.init(stringArray);
    }

    public static void onBoardOrPortChange() {
        examplesFolder = BaseNoGui.getContentFile("examples");
        toolsFolder = BaseNoGui.getContentFile("tools");
        librariesFolders = new ArrayList<File>();
        librariesFolders.add(BaseNoGui.getContentFile("libraries"));
        TargetPlatform targetPlatform = BaseNoGui.getTargetPlatform();
        if (targetPlatform != null) {
            Object object;
            TargetPlatform targetPlatform2;
            String string = (String)BaseNoGui.getBoardPreferences().get("build.core");
            if (string.contains(":") && (targetPlatform2 = BaseNoGui.getTargetPlatform((String)(object = string.split(":")[0]), targetPlatform.getId())) != null) {
                File file = targetPlatform2.getFolder();
                librariesFolders.add(new File(file, "libraries"));
            }
            object = targetPlatform.getFolder();
            librariesFolders.add(new File((File)object, "libraries"));
            librariesFolders.add(BaseNoGui.getSketchbookLibrariesFolder());
        }
        try {
            BaseNoGui.scanAndUpdateLibraries(librariesFolders);
        }
        catch (IOException iOException) {
            BaseNoGui.showWarning(I18n._("Error"), I18n._("Error loading libraries"), iOException);
        }
        BaseNoGui.populateImportToLibraryTable();
    }

    public static void populateImportToLibraryTable() {
        importToLibraryTable = new HashMap<String, Library>();
        for (Library library : BaseNoGui.getLibraries()) {
            try {
                String[] stringArray;
                for (String string : stringArray = BaseNoGui.headerListFromIncludePath(library.getSrcFolder())) {
                    Library library2 = importToLibraryTable.get(string);
                    if (library2 != null) {
                        String string2 = string.substring(0, string.length() - 2);
                        if (library2.getFolder().getPath().endsWith(string2)) continue;
                    }
                    importToLibraryTable.put(string, library);
                }
            }
            catch (IOException iOException) {
                BaseNoGui.showWarning(I18n._("Error"), I18n.format("Unable to list header files in {0}", library.getSrcFolder()), iOException);
            }
        }
    }

    public static void initParameters(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (stringArray[i].equals("--preferences-file")) {
                string = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("--curdir")) continue;
            currentDirectory = stringArray[++i];
        }
        PreferencesData.init(BaseNoGui.absoluteFile(string));
    }

    public static void removeDescendants(File file) {
        if (!file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
            File file2 = new File(file, stringArray[i]);
            if (!file2.isDirectory()) {
                if (PreferencesData.getBoolean("compiler.save_build_files") || file2.delete()) continue;
                System.err.println(I18n.format(I18n._("Could not delete {0}"), file2));
                continue;
            }
            BaseNoGui.removeDir(file2);
        }
    }

    public static void removeDir(File file) {
        if (file.exists()) {
            BaseNoGui.removeDescendants(file);
            if (!file.delete()) {
                System.err.println(I18n.format(I18n._("Could not delete {0}"), file));
            }
        }
    }

    public static String sanitizeName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray[0] >= '0' && cArray[0] <= '9') {
            stringBuffer.append('_');
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= '0' && cArray[i] <= '9' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= 'A' && cArray[i] <= 'Z' || i > 0 && cArray[i] == '-' || i > 0 && cArray[i] == '.') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            stringBuffer.append('_');
        }
        if (stringBuffer.length() > 63) {
            stringBuffer.setLength(63);
        }
        return stringBuffer.toString();
    }

    public static void saveFile(String string, File file) throws IOException {
        boolean bl;
        File file2 = File.createTempFile(file.getName(), null, file.getParentFile());
        PApplet.saveStrings(file2, new String[]{string});
        if (file.exists() && !(bl = file.delete())) {
            throw new IOException(I18n.format(I18n._("Could not remove old version of {0}"), file.getAbsolutePath()));
        }
        bl = file2.renameTo(file);
        if (!bl) {
            throw new IOException(I18n.format(I18n._("Could not replace {0}"), file.getAbsolutePath()));
        }
    }

    public static void scanAndUpdateLibraries(List<File> list) throws IOException {
        libraries = BaseNoGui.scanLibraries(list);
    }

    public static LibraryList scanLibraries(List<File> list) throws IOException {
        LibraryList libraryList = new LibraryList();
        for (File file : list) {
            libraryList.addOrReplaceAll(BaseNoGui.scanLibraries(file));
        }
        return libraryList;
    }

    public static LibraryList scanLibraries(File file) throws IOException {
        LibraryList libraryList = new LibraryList();
        String[] stringArray = file.list(new OnlyDirs());
        if (stringArray == null) {
            return libraryList;
        }
        for (String string : stringArray) {
            Object object;
            File file2 = new File(file, string);
            if (!BaseNoGui.isSanitaryName(string)) {
                object = I18n.format(I18n._("The library \"{0}\" cannot be used.\nLibrary names must contain only basic letters and numbers.\n(ASCII only and no spaces, and it cannot start with a number)"), string);
                BaseNoGui.showMessage(I18n._("Ignoring bad library name"), (String)object);
                continue;
            }
            try {
                object = Library.create(file2);
                if (object == null) continue;
                libraryList.addOrReplace((Library)object);
            }
            catch (IOException iOException) {
                System.out.println(I18n.format(I18n._("Invalid library found in {0}: {1}"), file2, iOException.getMessage()));
            }
        }
        return libraryList;
    }

    public static void selectBoard(TargetBoard targetBoard) {
        TargetPlatform targetPlatform = targetBoard.getContainerPlatform();
        TargetPackage targetPackage = targetPlatform.getContainerPackage();
        PreferencesData.set("target_package", targetPackage.getId());
        PreferencesData.set("target_platform", targetPlatform.getId());
        PreferencesData.set("board", targetBoard.getId());
        File file = targetPlatform.getFolder();
        PreferencesData.set("runtime.platform.path", file.getAbsolutePath());
        PreferencesData.set("runtime.hardware.path", file.getParentFile().getAbsolutePath());
    }

    public static void selectSerialPort(String string) {
        PreferencesData.set("serial.port", string);
        if (string.startsWith("/dev/")) {
            PreferencesData.set("serial.port.file", string.substring(5));
        } else {
            PreferencesData.set("serial.port.file", string);
        }
    }

    public static void setBuildFolder(File file) {
        buildFolder = file;
    }

    public static void showError(String string, String string2, int n) {
        BaseNoGui.showError(string, string2, null, n);
    }

    public static void showError(String string, String string2, Throwable throwable) {
        notifier.showError(string, string2, throwable, 1);
    }

    public static void showError(String string, String string2, Throwable throwable, int n) {
        notifier.showError(string, string2, throwable, n);
    }

    public static void showMessage(String string, String string2) {
        notifier.showMessage(string, string2);
    }

    public static void showWarning(String string, String string2, Exception exception) {
        notifier.showWarning(string, string2, exception);
    }

    static {
        currentDirectory = System.getProperty("user.dir");
        discoveryManager = new DiscoveryManager();
        notifier = new BasicUserNotifier();
        portableFolder = null;
    }
}

