/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.awt.Color;
import java.awt.Font;
import processing.app.helpers.PreferencesMap;

public abstract class PreferencesHelper {
    public static void putColor(PreferencesMap preferencesMap, String string, Color color) {
        preferencesMap.put(string, "#" + String.format("%06x", color.getRGB() & 0xFFFFFF));
    }

    public static Color parseColor(String string) {
        try {
            if (string.indexOf("#") == 0) {
                string = string.substring(1);
            }
            return new Color(Integer.parseInt(string, 16));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Font getFont(PreferencesMap preferencesMap, String string) {
        int n;
        String string2 = (String)preferencesMap.get(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split(",");
        if (stringArray.length != 3) {
            return null;
        }
        String string3 = stringArray[0];
        int n2 = 0;
        if (stringArray[1].contains("bold")) {
            n2 |= 1;
        }
        if (stringArray[1].contains("italic")) {
            n2 |= 2;
        }
        try {
            n = (int)Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            n = 12;
        }
        return new Font(string3, n2, n);
    }
}

