/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.I18n;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;

public class TargetBoard {
    private String id;
    private PreferencesMap prefs;
    private Map<String, PreferencesMap> menuOptions = new LinkedHashMap<String, PreferencesMap>();
    private TargetPlatform containerPlatform;

    public TargetBoard(String string, PreferencesMap preferencesMap, TargetPlatform targetPlatform) {
        this.containerPlatform = targetPlatform;
        this.id = string;
        this.prefs = new PreferencesMap(preferencesMap);
        PreferencesMap preferencesMap2 = this.prefs.firstLevelMap().get("menu");
        if (preferencesMap2 != null) {
            this.menuOptions = preferencesMap2.firstLevelMap();
        }
        if (!this.prefs.containsKey("build.board")) {
            String string2 = this.containerPlatform.getId() + "_" + this.id;
            string2 = string2.toUpperCase();
            this.prefs.put("build.board", string2);
            System.out.println(I18n.format(I18n._("Board {0}:{1}:{2} doesn''t define a ''build.board'' preference. Auto-set to: {3}"), this.containerPlatform.getContainerPackage().getId(), this.containerPlatform.getId(), this.id, string2));
        }
    }

    public String getName() {
        return (String)this.prefs.get("name");
    }

    public String getId() {
        return this.id;
    }

    public PreferencesMap getPreferences() {
        return this.prefs;
    }

    public boolean hasMenu(String string) {
        return this.menuOptions.containsKey(string);
    }

    public PreferencesMap getMenuLabels(String string) {
        return this.menuOptions.get(string).topLevelMap();
    }

    public String getMenuLabel(String string, String string2) {
        return (String)this.getMenuLabels(string).get(string2);
    }

    public Set<String> getMenuIds() {
        return this.menuOptions.keySet();
    }

    public PreferencesMap getMenuPreferences(String string, String string2) {
        return this.menuOptions.get(string).subTree(string2);
    }

    public TargetPlatform getContainerPlatform() {
        return this.containerPlatform;
    }
}

