/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import com.sun.jna.Library;
import com.sun.jna.Native;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.UIManager;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PConstants;

public class Platform {
    public void setLookAndFeel() throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    public void init() {
    }

    public File getSettingsFolder() throws Exception {
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, ".arduino15");
        return file2;
    }

    public File getDefaultSketchbookFolder() throws Exception {
        return null;
    }

    public void openURL(String string) throws Exception {
        String string2 = PreferencesData.get("launcher");
        if (string2 != null) {
            Runtime.getRuntime().exec(new String[]{string2, string});
        } else {
            this.showLauncherWarning();
        }
    }

    public boolean openFolderAvailable() {
        return PreferencesData.get("launcher") != null;
    }

    public void openFolder(File file) throws Exception {
        String string = PreferencesData.get("launcher");
        if (string != null) {
            String string2 = file.getAbsolutePath();
            Runtime.getRuntime().exec(new String[]{string, string2});
        } else {
            this.showLauncherWarning();
        }
    }

    public String resolveDeviceAttachedTo(String string, Map<String, TargetPackage> map, String string2) {
        return null;
    }

    public String preListAllCandidateDevices() {
        return null;
    }

    protected String resolveDeviceByVendorIdProductId(Map<String, TargetPackage> map, String string) {
        for (TargetPackage targetPackage : map.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard targetBoard : targetPlatform.getBoards().values()) {
                    LinkedList linkedList = new LinkedList(targetBoard.getPreferences().subTree("vid").values());
                    if (linkedList.isEmpty()) continue;
                    LinkedList linkedList2 = new LinkedList(targetBoard.getPreferences().subTree("pid").values());
                    for (int i = 0; i < linkedList.size(); ++i) {
                        String string2 = (String)linkedList.get(i) + "_" + (String)linkedList2.get(i);
                        if (!string2.toUpperCase().equals(string)) continue;
                        return targetBoard.getName();
                    }
                }
            }
        }
        return null;
    }

    public String resolveDeviceByBoardID(Map<String, TargetPackage> map, String string) {
        for (TargetPackage targetPackage : map.values()) {
            for (TargetPlatform targetPlatform : targetPackage.getPlatforms().values()) {
                for (TargetBoard targetBoard : targetPlatform.getBoards().values()) {
                    if (!string.equals(targetBoard.getId())) continue;
                    return targetBoard.getName();
                }
            }
        }
        return null;
    }

    public void setenv(String string, String string2) {
        CLibrary cLibrary = CLibrary.INSTANCE;
        cLibrary.setenv(string, string2, 1);
    }

    public String getenv(String string) {
        CLibrary cLibrary = CLibrary.INSTANCE;
        return cLibrary.getenv(string);
    }

    public int unsetenv(String string) {
        CLibrary cLibrary = CLibrary.INSTANCE;
        return cLibrary.unsetenv(string);
    }

    public String getName() {
        return PConstants.platformNames[0];
    }

    protected void showLauncherWarning() {
        BaseNoGui.showWarning(I18n._("No launcher available"), I18n._("Unspecified platform, no launcher available.\nTo enable opening URLs or folders, add a \n\"launcher=/path/to/app\" line to preferences.txt"), null);
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int setenv(String var1, String var2, int var3);

        public String getenv(String var1);

        public int unsetenv(String var1);

        public int putenv(String var1);
    }
}

