/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import cc.arduino.packages.ssh.SSH;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SCP
extends SSH {
    private Channel channel;
    private OutputStream out;
    private InputStream in;

    public SCP(Session session) {
        super(session);
    }

    public void open() throws IOException {
        try {
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand("scp -t -r -d /");
            this.out = this.channel.getOutputStream();
            this.in = this.channel.getInputStream();
            this.channel.connect();
            this.ensureAcknowledged();
        }
        catch (Exception exception) {
            this.close();
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.channel != null) {
            this.channel.disconnect();
        }
    }

    protected void ensureAcknowledged() throws IOException {
        this.out.flush();
        int n = this.in.read();
        if (n == 0) {
            return;
        }
        if (n == -1) {
            return;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SCP error: ");
            do {
                n2 = this.in.read();
                stringBuilder.append((char)n2);
            } while (n2 != 10);
            throw new IOException(stringBuilder.toString());
        }
        throw new IOException("Uknown SCP error: " + n);
    }

    public void sendFile(File file) throws IOException {
        this.sendFile(file, file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(File file, String string) throws IOException {
        this.out.write(("C0644 " + file.length() + " " + string + "\n").getBytes());
        this.ensureAcknowledged();
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[4096];
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
                this.out.write(byArray, 0, n);
            }
            byArray[0] = 0;
            this.out.write(byArray, 0, 1);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        this.ensureAcknowledged();
    }

    public void startFolder(String string) throws IOException {
        this.out.write(("D0755 0 " + string + "\n").getBytes());
        this.ensureAcknowledged();
    }

    public void endFolder() throws IOException {
        this.out.write("E\n".getBytes());
        this.ensureAcknowledged();
    }
}

