/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.network;

import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.NetworkTopologyDiscovery;

public class NetworkChecker
extends TimerTask {
    private final NetworkTopologyListener topologyListener;
    private final NetworkTopologyDiscovery topology;
    private Set<InetAddress> knownAddresses;

    public NetworkChecker(NetworkTopologyListener networkTopologyListener, NetworkTopologyDiscovery networkTopologyDiscovery) {
        this.topologyListener = networkTopologyListener;
        this.topology = networkTopologyDiscovery;
        this.knownAddresses = Collections.synchronizedSet(new HashSet());
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        try {
            InetAddress[] inetAddressArray = this.topology.getInetAddresses();
            HashSet<InetAddress> hashSet = new HashSet<InetAddress>(inetAddressArray.length);
            for (InetAddress inetAddress : inetAddressArray) {
                hashSet.add(inetAddress);
                if (this.knownAddresses.contains(inetAddress)) continue;
                this.topologyListener.inetAddressAdded(inetAddress);
            }
            for (InetAddress inetAddress : this.knownAddresses) {
                if (hashSet.contains(inetAddress)) continue;
                this.topologyListener.inetAddressRemoved(inetAddress);
            }
            this.knownAddresses = hashSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

