/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.Waiter;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jnlp.FileContents;
import javax.jnlp.FileSaveService;

public final class FileSaveServiceImpl
implements FileSaveService {
    static FileSaveServiceImpl _sharedInstance = null;
    private ApiDialog _apiDialog = new ApiDialog();
    private String _lastPath;

    private FileSaveServiceImpl() {
    }

    public static synchronized FileSaveService getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new FileSaveServiceImpl();
        }
        return _sharedInstance;
    }

    String getLastPath() {
        return this._lastPath;
    }

    void setLastPath(String string) {
        this._lastPath = string;
    }

    public FileContents saveAsFileDialog(String string, String[] stringArray, FileContents fileContents) throws IOException {
        return this.saveFileDialog(string, stringArray, fileContents.getInputStream(), fileContents.getName());
    }

    public FileContents saveFileDialog(final String string, final String[] stringArray, final InputStream inputStream, final String string2) throws IOException {
        if (!this.askUser()) {
            return null;
        }
        Waiter.WaiterTask waiterTask = new Waiter.WaiterTask(){

            public Object run() throws Exception {
                Object object = DeploySysRun.executePrivileged((DeploySysAction)new DeploySysAction(){

                    public Object execute() {
                        File[] fileArray;
                        String string = string;
                        if (string == null) {
                            string = FileSaveServiceImpl.this.getLastPath();
                        }
                        if ((fileArray = ToolkitStore.getUI().showFileChooser(string, stringArray, 9, false, string2))[0] != null) {
                            try {
                                byte[] byArray = new byte[8192];
                                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(fileArray[0]));
                                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                                int n = bufferedInputStream.read(byArray);
                                while (n != -1) {
                                    bufferedOutputStream.write(byArray, 0, n);
                                    n = bufferedInputStream.read(byArray);
                                }
                                bufferedOutputStream.close();
                                FileSaveServiceImpl.this.setLastPath(fileArray[0].getPath());
                                return new FileContentsImpl(fileArray[0], FileSaveServiceImpl.computeMaxLength(fileArray[0].length()));
                            }
                            catch (IOException iOException) {
                                Trace.ignored((Throwable)iOException);
                                return iOException;
                            }
                        }
                        return null;
                    }
                }, null);
                if (object instanceof IOException) {
                    throw (IOException)object;
                }
                return (FileContents)object;
            }
        };
        try {
            return (FileContents)Waiter.runAndWait((Waiter.WaiterTask)waiterTask);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            Trace.ignored((Throwable)exception);
            return null;
        }
    }

    synchronized boolean askUser() {
        if (CheckServicePermission.hasFileAccessPermissions()) {
            return true;
        }
        return this._apiDialog.askUser(ResourceManager.getString((String)"api.file.save.title"), ResourceManager.getString((String)"api.file.save.message"), ResourceManager.getString((String)"api.file.save.always"));
    }

    static long computeMaxLength(long l) {
        return l * 3L;
    }
}

