/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import sun.awt.OSInfo;
import sun.awt.shell.ShellFolder;

public class WindowsPlacesBar
extends JToolBar
implements ActionListener,
PropertyChangeListener {
    JFileChooser fc;
    JToggleButton[] buttons;
    ButtonGroup buttonGroup;
    File[] files;
    final Dimension buttonSize;

    public WindowsPlacesBar(JFileChooser jFileChooser, boolean bl) {
        super(1);
        boolean bl2;
        this.fc = jFileChooser;
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        boolean bl3 = bl2 = OSInfo.getOSType() == OSInfo.OSType.WINDOWS && OSInfo.getWindowsVersion().compareTo(OSInfo.WINDOWS_XP) >= 0;
        if (bl) {
            this.buttonSize = new Dimension(83, 69);
            this.putClientProperty("XPStyle.subAppName", "placesbar");
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        } else {
            this.buttonSize = new Dimension(83, bl2 ? 65 : 54);
            this.setBorder(new BevelBorder(1, UIManager.getColor("ToolBar.highlight"), UIManager.getColor("ToolBar.background"), UIManager.getColor("ToolBar.darkShadow"), UIManager.getColor("ToolBar.shadow")));
        }
        Color color = new Color(UIManager.getColor("ToolBar.shadow").getRGB());
        this.setBackground(color);
        FileSystemView fileSystemView = jFileChooser.getFileSystemView();
        this.files = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return (File[])ShellFolder.get("fileChooserShortcutPanelFolders");
            }
        });
        this.buttons = new JToggleButton[this.files.length];
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < this.files.length; ++i) {
            Icon icon;
            Serializable serializable;
            String string;
            int n;
            if (fileSystemView.isFileSystemRoot(this.files[i])) {
                this.files[i] = fileSystemView.createFileObject(this.files[i].getAbsolutePath());
            }
            if ((n = (string = fileSystemView.getSystemDisplayName(this.files[i])).lastIndexOf(File.separatorChar)) >= 0 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (this.files[i] instanceof ShellFolder) {
                serializable = (ShellFolder)this.files[i];
                Image image = serializable.getIcon(true);
                if (image == null) {
                    image = (Image)ShellFolder.get("shell32LargeIcon 1");
                }
                icon = image == null ? null : new ImageIcon(image, serializable.getFolderType());
            } else {
                icon = fileSystemView.getSystemIcon(this.files[i]);
            }
            this.buttons[i] = new JToggleButton(string, icon);
            if (bl2) {
                this.buttons[i].setText("<html><center>" + string + "</center></html>");
            }
            if (bl) {
                this.buttons[i].putClientProperty("XPStyle.subAppName", "placesbar");
            } else {
                serializable = new Color(UIManager.getColor("List.selectionForeground").getRGB());
                this.buttons[i].setContentAreaFilled(false);
                this.buttons[i].setForeground((Color)serializable);
            }
            this.buttons[i].setMargin(new Insets(3, 2, 1, 2));
            this.buttons[i].setFocusPainted(false);
            this.buttons[i].setIconTextGap(0);
            this.buttons[i].setHorizontalTextPosition(0);
            this.buttons[i].setVerticalTextPosition(3);
            this.buttons[i].setAlignmentX(0.5f);
            this.buttons[i].setPreferredSize(this.buttonSize);
            this.buttons[i].setMaximumSize(this.buttonSize);
            this.buttons[i].addActionListener(this);
            this.add(this.buttons[i]);
            if (i < this.files.length - 1 && bl) {
                this.add(Box.createRigidArea(new Dimension(1, 1)));
            }
            this.buttonGroup.add(this.buttons[i]);
        }
        this.doDirectoryChanged(jFileChooser.getCurrentDirectory());
    }

    protected void doDirectoryChanged(File file) {
        for (int i = 0; i < this.buttons.length; ++i) {
            JToggleButton jToggleButton = this.buttons[i];
            if (this.files[i].equals(file)) {
                jToggleButton.setSelected(true);
                break;
            }
            if (!jToggleButton.isSelected()) continue;
            this.buttonGroup.remove(jToggleButton);
            jToggleButton.setSelected(false);
            this.buttonGroup.add(jToggleButton);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "directoryChanged") {
            this.doDirectoryChanged(this.fc.getCurrentDirectory());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
        for (int i = 0; i < this.buttons.length; ++i) {
            if (jToggleButton != this.buttons[i]) continue;
            this.fc.setCurrentDirectory(this.files[i]);
            break;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        JToggleButton jToggleButton;
        Dimension dimension = super.getMinimumSize();
        Dimension dimension2 = super.getPreferredSize();
        int n2 = dimension.height;
        if (this.buttons != null && this.buttons.length > 0 && this.buttons.length < 5 && (jToggleButton = this.buttons[0]) != null && (n = 5 * (jToggleButton.getPreferredSize().height + 1)) > n2) {
            n2 = n;
        }
        if (n2 > dimension2.height) {
            dimension2 = new Dimension(dimension2.width, n2);
        }
        return dimension2;
    }
}

