/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

final class ProcessImpl
extends Process {
    private static final JavaIOFileDescriptorAccess fdAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
    private static final int VERIFICATION_CMD_BAT = 0;
    private static final int VERIFICATION_WIN32 = 1;
    private static final int VERIFICATION_LEGACY = 2;
    private static final char[][] ESCAPE_VERIFICATION = new char[][]{{' ', '\t', '<', '>', '&', '|', '^'}, {' ', '\t', '<', '>'}, {' ', '\t'}};
    private long handle = 0L;
    private OutputStream stdin_stream;
    private InputStream stdout_stream;
    private InputStream stderr_stream;
    private static final int STILL_ACTIVE = ProcessImpl.getStillActive();

    private static FileOutputStream newFileOutputStream(File file, boolean bl) throws IOException {
        if (bl) {
            String string = file.getPath();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkWrite(string);
            }
            long l = ProcessImpl.openForAtomicAppend(string);
            final FileDescriptor fileDescriptor = new FileDescriptor();
            fdAccess.setHandle(fileDescriptor, l);
            return AccessController.doPrivileged(new PrivilegedAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() {
                    return new FileOutputStream(fileDescriptor);
                }
            });
        }
        return new FileOutputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Process start(String[] stringArray, Map<String, String> map, String string, ProcessBuilder.Redirect[] redirectArray, boolean bl) throws IOException {
        String string2 = ProcessEnvironment.toEnvironmentBlock(map);
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileOutputStream fileOutputStream2 = null;
        try {
            long[] lArray;
            if (redirectArray == null) {
                lArray = new long[]{-1L, -1L, -1L};
            } else {
                lArray = new long[3];
                if (redirectArray[0] == ProcessBuilder.Redirect.PIPE) {
                    lArray[0] = -1L;
                } else if (redirectArray[0] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[0] = fdAccess.getHandle(FileDescriptor.in);
                } else {
                    fileInputStream = new FileInputStream(redirectArray[0].file());
                    lArray[0] = fdAccess.getHandle(fileInputStream.getFD());
                }
                if (redirectArray[1] == ProcessBuilder.Redirect.PIPE) {
                    lArray[1] = -1L;
                } else if (redirectArray[1] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[1] = fdAccess.getHandle(FileDescriptor.out);
                } else {
                    fileOutputStream = ProcessImpl.newFileOutputStream(redirectArray[1].file(), redirectArray[1].append());
                    lArray[1] = fdAccess.getHandle(fileOutputStream.getFD());
                }
                if (redirectArray[2] == ProcessBuilder.Redirect.PIPE) {
                    lArray[2] = -1L;
                } else if (redirectArray[2] == ProcessBuilder.Redirect.INHERIT) {
                    lArray[2] = fdAccess.getHandle(FileDescriptor.err);
                } else {
                    fileOutputStream2 = ProcessImpl.newFileOutputStream(redirectArray[2].file(), redirectArray[2].append());
                    lArray[2] = fdAccess.getHandle(fileOutputStream2.getFD());
                }
            }
            ProcessImpl processImpl = new ProcessImpl(stringArray, string2, string, lArray, bl);
            return processImpl;
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                finally {
                    if (fileOutputStream2 != null) {
                        fileOutputStream2.close();
                    }
                }
            }
        }
    }

    private static String[] getTokensFromCommand(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(8);
        Matcher matcher = LazyPattern.PATTERN.matcher(string);
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String createCommandLine(int n, String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(string);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuilder.append(' ');
            String string2 = stringArray[i];
            if (ProcessImpl.needsEscaping(n, string2)) {
                stringBuilder.append('\"').append(string2);
                if (n != 0 && string2.endsWith("\\")) {
                    stringBuilder.append('\\');
                }
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static boolean isQuoted(boolean bl, String string, String string2) {
        int n = string.length() - 1;
        if (n >= 1 && string.charAt(0) == '\"' && string.charAt(n) == '\"') {
            if (bl && string.indexOf(34, 1) != n) {
                throw new IllegalArgumentException(string2);
            }
            return true;
        }
        if (bl && string.indexOf(34) >= 0) {
            throw new IllegalArgumentException(string2);
        }
        return false;
    }

    private static boolean needsEscaping(int n, String string) {
        boolean bl = ProcessImpl.isQuoted(n == 0, string, "Argument has embedded quote, use the explicit CMD.EXE call.");
        if (!bl) {
            char[] cArray = ESCAPE_VERIFICATION[n];
            for (int i = 0; i < cArray.length; ++i) {
                if (string.indexOf(cArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static String getExecutablePath(String string) throws IOException {
        boolean bl = ProcessImpl.isQuoted(true, string, "Executable name has embedded quote, split the arguments");
        File file = new File(bl ? string.substring(1, string.length() - 1) : string);
        return file.getPath();
    }

    private boolean isShellFile(String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(".CMD") || string2.endsWith(".BAT");
    }

    private String quoteString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        return stringBuilder.append('\"').append(string).append('\"').toString();
    }

    private ProcessImpl(String[] stringArray, String string, String string2, final long[] lArray, boolean bl) throws IOException {
        String string3;
        String string4;
        SecurityManager securityManager = System.getSecurityManager();
        boolean bl2 = false;
        if (securityManager == null) {
            bl2 = true;
            string4 = System.getProperty("jdk.lang.Process.allowAmbiguousCommands");
            if (string4 != null) {
                boolean bl3 = bl2 = !"false".equalsIgnoreCase(string4);
            }
        }
        if (bl2) {
            string4 = new File(stringArray[0]).getPath();
            if (ProcessImpl.needsEscaping(2, string4)) {
                string4 = this.quoteString(string4);
            }
            string3 = ProcessImpl.createCommandLine(2, string4, stringArray);
        } else {
            block8: {
                try {
                    string4 = ProcessImpl.getExecutablePath(stringArray[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string5 : stringArray) {
                        stringBuilder.append(string5).append(' ');
                    }
                    stringArray = ProcessImpl.getTokensFromCommand(stringBuilder.toString());
                    string4 = ProcessImpl.getExecutablePath(stringArray[0]);
                    if (securityManager == null) break block8;
                    securityManager.checkExec(string4);
                }
            }
            string3 = ProcessImpl.createCommandLine(this.isShellFile(string4) ? 0 : 1, this.quoteString(string4), stringArray);
        }
        this.handle = ProcessImpl.create(string3, string, string2, lArray, bl);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FileDescriptor fileDescriptor;
                if (lArray[0] == -1L) {
                    ProcessImpl.this.stdin_stream = ProcessBuilder.NullOutputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[0]);
                    ProcessImpl.this.stdin_stream = new BufferedOutputStream(new FileOutputStream(fileDescriptor));
                }
                if (lArray[1] == -1L) {
                    ProcessImpl.this.stdout_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[1]);
                    ProcessImpl.this.stdout_stream = new BufferedInputStream(new FileInputStream(fileDescriptor));
                }
                if (lArray[2] == -1L) {
                    ProcessImpl.this.stderr_stream = ProcessBuilder.NullInputStream.INSTANCE;
                } else {
                    fileDescriptor = new FileDescriptor();
                    fdAccess.setHandle(fileDescriptor, lArray[2]);
                    ProcessImpl.this.stderr_stream = new FileInputStream(fileDescriptor);
                }
                return null;
            }
        });
    }

    @Override
    public OutputStream getOutputStream() {
        return this.stdin_stream;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout_stream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr_stream;
    }

    public void finalize() {
        ProcessImpl.closeHandle(this.handle);
    }

    private static native int getStillActive();

    @Override
    public int exitValue() {
        int n = ProcessImpl.getExitCodeProcess(this.handle);
        if (n == STILL_ACTIVE) {
            throw new IllegalThreadStateException("process has not exited");
        }
        return n;
    }

    private static native int getExitCodeProcess(long var0);

    @Override
    public int waitFor() throws InterruptedException {
        ProcessImpl.waitForInterruptibly(this.handle);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.exitValue();
    }

    private static native void waitForInterruptibly(long var0);

    @Override
    public void destroy() {
        ProcessImpl.terminateProcess(this.handle);
    }

    private static native void terminateProcess(long var0);

    private static native long create(String var0, String var1, String var2, long[] var3, boolean var4) throws IOException;

    private static native long openForAtomicAppend(String var0) throws IOException;

    private static native boolean closeHandle(long var0);

    private static class LazyPattern {
        private static final Pattern PATTERN = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");

        private LazyPattern() {
        }
    }
}

