/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.util;

import com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ParserPool {
    private final BlockingQueue queue;
    private SAXParserFactory factory;
    private int capacity;

    public ParserPool(int n) {
        this.capacity = n;
        this.queue = new ArrayBlockingQueue(n);
        this.factory = new SAXParserFactoryImpl();
        this.factory.setNamespaceAware(true);
        for (int i = 0; i < n; ++i) {
            try {
                this.queue.put(this.factory.newSAXParser());
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(interruptedException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new RuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new RuntimeException(sAXException);
            }
        }
    }

    public SAXParser get() throws ParserConfigurationException, SAXException {
        try {
            return (SAXParser)this.queue.take();
        }
        catch (InterruptedException interruptedException) {
            throw new SAXException(interruptedException);
        }
    }

    public void put(SAXParser sAXParser) {
        this.queue.offer(sAXParser);
    }

    public void returnParser(SAXParser sAXParser) {
        sAXParser.reset();
        this.resetSaxParser(sAXParser);
        this.put(sAXParser);
    }

    private void resetSaxParser(SAXParser sAXParser) {
        try {
            SymbolTable symbolTable = new SymbolTable();
            sAXParser.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }
}

