/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap.impl;

import com.sun.xml.internal.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.internal.messaging.saaj.soap.Envelope;
import com.sun.xml.internal.messaging.saaj.soap.SOAPDocumentImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.BodyImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.ElementImpl;
import com.sun.xml.internal.messaging.saaj.soap.impl.HeaderImpl;
import com.sun.xml.internal.messaging.saaj.soap.name.NameImpl;
import com.sun.xml.internal.messaging.saaj.util.FastInfosetReflection;
import com.sun.xml.internal.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

public abstract class EnvelopeImpl
extends ElementImpl
implements Envelope {
    protected HeaderImpl header;
    protected BodyImpl body;
    String omitXmlDecl = "yes";
    String charset = "utf-8";
    String xmlDecl = null;

    protected EnvelopeImpl(SOAPDocumentImpl sOAPDocumentImpl, Name name) {
        super(sOAPDocumentImpl, name);
    }

    protected EnvelopeImpl(SOAPDocumentImpl sOAPDocumentImpl, QName qName) {
        super(sOAPDocumentImpl, qName);
    }

    protected EnvelopeImpl(SOAPDocumentImpl sOAPDocumentImpl, NameImpl nameImpl, boolean bl, boolean bl2) throws SOAPException {
        this(sOAPDocumentImpl, nameImpl);
        this.ensureNamespaceIsDeclared(this.getElementQName().getPrefix(), this.getElementQName().getNamespaceURI());
        if (bl) {
            this.addHeader();
        }
        if (bl2) {
            this.addBody();
        }
    }

    protected abstract NameImpl getHeaderName(String var1);

    protected abstract NameImpl getBodyName(String var1);

    @Override
    public SOAPHeader addHeader() throws SOAPException {
        return this.addHeader(null);
    }

    public SOAPHeader addHeader(String string) throws SOAPException {
        if (string == null || string.equals("")) {
            string = this.getPrefix();
        }
        NameImpl nameImpl = this.getHeaderName(string);
        NameImpl nameImpl2 = this.getBodyName(string);
        HeaderImpl headerImpl = null;
        SOAPElement sOAPElement = null;
        Iterator iterator = this.getChildElementNodes();
        if (iterator.hasNext()) {
            sOAPElement = (SOAPElement)iterator.next();
            if (sOAPElement.getElementName().equals(nameImpl)) {
                log.severe("SAAJ0120.impl.header.already.exists");
                throw new SOAPExceptionImpl("Can't add a header when one is already present.");
            }
            if (!sOAPElement.getElementName().equals(nameImpl2)) {
                log.severe("SAAJ0121.impl.invalid.first.child.of.envelope");
                throw new SOAPExceptionImpl("First child of Envelope must be either a Header or Body");
            }
        }
        headerImpl = (HeaderImpl)this.createElement(nameImpl);
        this.insertBefore(headerImpl, sOAPElement);
        headerImpl.ensureNamespaceIsDeclared(nameImpl.getPrefix(), nameImpl.getURI());
        return headerImpl;
    }

    protected void lookForHeader() throws SOAPException {
        HeaderImpl headerImpl;
        NameImpl nameImpl = this.getHeaderName(null);
        this.header = headerImpl = (HeaderImpl)this.findChild(nameImpl);
    }

    @Override
    public SOAPHeader getHeader() throws SOAPException {
        this.lookForHeader();
        return this.header;
    }

    protected void lookForBody() throws SOAPException {
        BodyImpl bodyImpl;
        NameImpl nameImpl = this.getBodyName(null);
        this.body = bodyImpl = (BodyImpl)this.findChild(nameImpl);
    }

    @Override
    public SOAPBody addBody() throws SOAPException {
        return this.addBody(null);
    }

    public SOAPBody addBody(String string) throws SOAPException {
        this.lookForBody();
        if (string == null || string.equals("")) {
            string = this.getPrefix();
        }
        if (this.body != null) {
            log.severe("SAAJ0122.impl.body.already.exists");
            throw new SOAPExceptionImpl("Can't add a body when one is already present.");
        }
        NameImpl nameImpl = this.getBodyName(string);
        this.body = (BodyImpl)this.createElement(nameImpl);
        this.insertBefore(this.body, null);
        this.body.ensureNamespaceIsDeclared(nameImpl.getPrefix(), nameImpl.getURI());
        return this.body;
    }

    @Override
    protected SOAPElement addElement(Name name) throws SOAPException {
        if (this.getBodyName(null).equals(name)) {
            return this.addBody(name.getPrefix());
        }
        if (this.getHeaderName(null).equals(name)) {
            return this.addHeader(name.getPrefix());
        }
        return super.addElement(name);
    }

    @Override
    protected SOAPElement addElement(QName qName) throws SOAPException {
        if (this.getBodyName(null).equals(NameImpl.convertToName(qName))) {
            return this.addBody(qName.getPrefix());
        }
        if (this.getHeaderName(null).equals(NameImpl.convertToName(qName))) {
            return this.addHeader(qName.getPrefix());
        }
        return super.addElement(qName);
    }

    @Override
    public SOAPBody getBody() throws SOAPException {
        this.lookForBody();
        return this.body;
    }

    @Override
    public Source getContent() {
        return new DOMSource(this.getOwnerDocument());
    }

    @Override
    public Name createName(String string, String string2, String string3) throws SOAPException {
        if ("xmlns".equals(string2)) {
            log.severe("SAAJ0123.impl.no.reserved.xmlns");
            throw new SOAPExceptionImpl("Cannot declare reserved xmlns prefix");
        }
        if (string2 == null && "xmlns".equals(string)) {
            log.severe("SAAJ0124.impl.qualified.name.cannot.be.xmlns");
            throw new SOAPExceptionImpl("Qualified name cannot be xmlns");
        }
        return NameImpl.create(string, string2, string3);
    }

    public Name createName(String string, String string2) throws SOAPException {
        String string3 = this.getNamespaceURI(string2);
        if (string3 == null) {
            log.log(Level.SEVERE, "SAAJ0126.impl.cannot.locate.ns", new String[]{string2});
            throw new SOAPExceptionImpl("Unable to locate namespace for prefix " + string2);
        }
        return NameImpl.create(string, string2, string3);
    }

    @Override
    public Name createName(String string) throws SOAPException {
        return NameImpl.createFromUnqualifiedName(string);
    }

    public void setOmitXmlDecl(String string) {
        this.omitXmlDecl = string;
    }

    public void setXmlDecl(String string) {
        this.xmlDecl = string;
    }

    private String getOmitXmlDecl() {
        return this.omitXmlDecl;
    }

    public void setCharsetEncoding(String string) {
        this.charset = string;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", this.charset);
            if (this.omitXmlDecl.equals("no") && this.xmlDecl == null) {
                this.xmlDecl = "<?xml version=\"" + this.getOwnerDocument().getXmlVersion() + "\" encoding=\"" + this.charset + "\" ?>";
            }
            StreamResult streamResult = new StreamResult(outputStream);
            if (this.xmlDecl != null) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.charset);
                outputStreamWriter.write(this.xmlDecl);
                outputStreamWriter.flush();
                streamResult = new StreamResult(outputStreamWriter);
            }
            log.log(Level.FINE, "SAAJ0190.impl.set.xml.declaration", new String[]{this.omitXmlDecl});
            log.log(Level.FINE, "SAAJ0191.impl.set.encoding", new String[]{this.charset});
            transformer.transform(this.getContent(), streamResult);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    @Override
    public void output(OutputStream outputStream, boolean bl) throws IOException {
        if (!bl) {
            this.output(outputStream);
        } else {
            try {
                Source source = this.getContent();
                Transformer transformer = EfficientStreamingTransformer.newTransformer();
                transformer.transform(this.getContent(), FastInfosetReflection.FastInfosetResult_new(outputStream));
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
    }

    @Override
    public SOAPElement setElementQName(QName qName) throws SOAPException {
        log.log(Level.SEVERE, "SAAJ0146.impl.invalid.name.change.requested", new Object[]{this.elementQName.getLocalPart(), qName.getLocalPart()});
        throw new SOAPException("Cannot change name for " + this.elementQName.getLocalPart() + " to " + qName.getLocalPart());
    }
}

