/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Resolver {
    private DnsClient dnsClient;
    private int timeout;
    private int retries;

    Resolver(String[] stringArray, int n, int n2) throws NamingException {
        this.timeout = n;
        this.retries = n2;
        this.dnsClient = new DnsClient(stringArray, n, n2);
    }

    public void close() {
        this.dnsClient.close();
        this.dnsClient = null;
    }

    ResourceRecords query(DnsName dnsName, int n, int n2, boolean bl, boolean bl2) throws NamingException {
        return this.dnsClient.query(dnsName, n, n2, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName dnsName, int n, boolean bl) throws NamingException {
        try (DnsClient dnsClient = new DnsClient(this.findNameServers(dnsName, bl), this.timeout, this.retries);){
            ResourceRecords resourceRecords = dnsClient.queryZone(dnsName, n, bl);
            return resourceRecords;
        }
    }

    DnsName findZoneName(DnsName dnsName, int n, boolean bl) throws NamingException {
        dnsName = (DnsName)dnsName.clone();
        while (dnsName.size() > 1) {
            ResourceRecords resourceRecords = null;
            try {
                resourceRecords = this.query(dnsName, n, 6, bl, false);
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (resourceRecords != null) {
                if (resourceRecords.answer.size() > 0) {
                    return dnsName;
                }
                for (int i = 0; i < resourceRecords.authority.size(); ++i) {
                    DnsName dnsName2;
                    ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.authority.elementAt(i);
                    if (resourceRecord.getType() != 6 || !dnsName.endsWith(dnsName2 = resourceRecord.getName())) continue;
                    return dnsName2;
                }
            }
            dnsName.remove(dnsName.size() - 1);
        }
        return dnsName;
    }

    ResourceRecord findSoa(DnsName dnsName, int n, boolean bl) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, n, 6, bl, false);
        for (int i = 0; i < resourceRecords.answer.size(); ++i) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(i);
            if (resourceRecord.getType() != 6) continue;
            return resourceRecord;
        }
        return null;
    }

    private String[] findNameServers(DnsName dnsName, boolean bl) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, 1, 2, bl, false);
        String[] stringArray = new String[resourceRecords.answer.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(i);
            if (resourceRecord.getType() != 2) {
                throw new CommunicationException("Corrupted DNS message");
            }
            stringArray[i] = (String)resourceRecord.getRdata();
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
        }
        return stringArray;
    }
}

