/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import processing.app.helpers.FileUtils;
import processing.app.packages.Library;

public class LibraryList
extends ArrayList<Library> {
    public LibraryList(LibraryList libraryList) {
        super(libraryList);
    }

    public LibraryList() {
    }

    public Library getByName(String string) {
        for (Library library : this) {
            if (!library.getName().equals(string)) continue;
            return library;
        }
        return null;
    }

    public void addOrReplace(Library library) {
        Library library2 = this.getByName(library.getName());
        if (library2 != null) {
            this.remove(library2);
        }
        this.add(library);
    }

    public void addOrReplaceAll(Collection<? extends Library> collection) {
        for (Library library : collection) {
            this.addOrReplace(library);
        }
    }

    public void sort() {
        Collections.sort(this, Library.CASE_INSENSITIVE_ORDER);
    }

    public Library search(String string, String string2) {
        for (Library library : this) {
            if (!library.getName().equals(string) || !library.supportsArchitecture(string2)) continue;
            return library;
        }
        return null;
    }

    public LibraryList filterByArchitecture(String string) {
        LibraryList libraryList = new LibraryList();
        for (Library library : this) {
            if (!library.supportsArchitecture(string)) continue;
            libraryList.add(library);
        }
        return libraryList;
    }

    public LibraryList filterLibrariesInSubfolder(File file) {
        LibraryList libraryList = new LibraryList();
        for (Library library : this) {
            if (!FileUtils.isSubDirectory(file, library.getFolder())) continue;
            libraryList.add(library);
        }
        return libraryList;
    }
}

