/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import processing.app.helpers.OSUtils;
import processing.app.helpers.PreferencesMapException;
import processing.app.legacy.PApplet;

public class PreferencesMap
extends LinkedHashMap<String, String> {
    public PreferencesMap(Map<String, String> map) {
        super(map);
    }

    public PreferencesMap(File file) throws IOException {
        this.load(file);
    }

    public PreferencesMap() {
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    protected String processPlatformSuffix(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (!string.endsWith(string2)) {
            return string;
        }
        if (!bl) {
            return null;
        }
        return string.substring(0, string.length() - string2.length());
    }

    public void load(InputStream inputStream) throws IOException {
        String[] stringArray;
        for (String string : stringArray = PApplet.loadStrings(inputStream)) {
            int n;
            if (string.length() == 0 || string.charAt(0) == '#' || (n = string.indexOf(61)) == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            string2 = this.processPlatformSuffix(string2, ".linux", OSUtils.isLinux());
            string2 = this.processPlatformSuffix(string2, ".windows", OSUtils.isWindows());
            if ((string2 = this.processPlatformSuffix(string2, ".macosx", OSUtils.isMacOS())) == null) continue;
            this.put(string2, string3);
        }
    }

    public PreferencesMap topLevelMap() {
        PreferencesMap preferencesMap = new PreferencesMap();
        for (String string : this.keySet()) {
            if (string.contains(".")) continue;
            preferencesMap.put(string, this.get(string));
        }
        return preferencesMap;
    }

    public Map<String, PreferencesMap> firstLevelMap() {
        LinkedHashMap<String, PreferencesMap> linkedHashMap = new LinkedHashMap<String, PreferencesMap>();
        for (String string : this.keySet()) {
            int n = string.indexOf(46);
            if (n == -1) continue;
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (!linkedHashMap.containsKey(string2)) {
                linkedHashMap.put(string2, new PreferencesMap());
            }
            ((PreferencesMap)linkedHashMap.get(string2)).put(string3, this.get(string));
        }
        return linkedHashMap;
    }

    public PreferencesMap subTree(String string) {
        PreferencesMap preferencesMap = new PreferencesMap();
        string = string + ".";
        int n = string.length();
        for (String string2 : this.keySet()) {
            if (!string2.startsWith(string)) continue;
            preferencesMap.put(string2.substring(n), this.get(string2));
        }
        return preferencesMap;
    }

    public String toString(String string) {
        String string2 = string + "{\n";
        TreeSet treeSet = new TreeSet(this.keySet());
        for (String string3 : treeSet) {
            string2 = string2 + string + string3 + " = " + (String)this.get(string3) + "\n";
        }
        return string2;
    }

    public String getOrExcept(String string) throws PreferencesMapException {
        String string2 = (String)this.get(string);
        if (string2 == null) {
            throw new PreferencesMapException(string);
        }
        return string2;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public File getFile(String string) {
        if (!this.containsKey(string)) {
            return null;
        }
        String string2 = ((String)this.get(string)).trim();
        if (string2.length() == 0) {
            return null;
        }
        return new File(string2);
    }

    public File getFile(String string, String string2) {
        File file = this.getFile(string);
        if (file == null) {
            return null;
        }
        return new File(file, string2);
    }

    public boolean getBoolean(String string) {
        return new Boolean((String)this.get(string));
    }

    public boolean putBoolean(String string, boolean bl) {
        String string2 = this.put(string, bl ? "true" : "false");
        return new Boolean(string2);
    }
}

