/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatform;
import processing.app.legacy.PApplet;

public class CommandlineParser {
    private ACTION action = ACTION.GUI;
    private boolean doVerboseBuild = false;
    private boolean doVerboseUpload = false;
    private boolean doUseProgrammer = false;
    private boolean noUploadPort = false;
    private boolean forceSavePrefs = false;
    private String getPref = null;
    private List<String> filenames = new LinkedList<String>();

    public static CommandlineParser newCommandlineParser(String[] stringArray) {
        return new CommandlineParser(stringArray);
    }

    private CommandlineParser(String[] stringArray) {
        this.parseArguments(stringArray);
        this.checkAction();
    }

    private void parseArguments(String[] stringArray) {
        HashMap<String, ACTION> hashMap = new HashMap<String, ACTION>();
        hashMap.put("--verify", ACTION.VERIFY);
        hashMap.put("--upload", ACTION.UPLOAD);
        hashMap.put("--get-pref", ACTION.GET_PREF);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            ACTION aCTION = (ACTION)((Object)hashMap.get(stringArray[i]));
            if (aCTION != null) {
                if (this.action != ACTION.GUI && this.action != ACTION.NOOP) {
                    object = hashMap.keySet().toArray(new String[0]);
                    String string = I18n.format(I18n._("Can only pass one of: {0}"), PApplet.join((String[])object, ", "));
                    BaseNoGui.showError(null, string, 3);
                }
                if (aCTION == ACTION.GET_PREF) {
                    if (++i >= stringArray.length) {
                        BaseNoGui.showError(null, I18n._("Argument required for --get-pref"), 3);
                    }
                    this.getPref = stringArray[i];
                }
                this.action = aCTION;
                continue;
            }
            if (stringArray[i].equals("--verbose") || stringArray[i].equals("-v")) {
                this.doVerboseBuild = true;
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--verbose-build")) {
                this.doVerboseBuild = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--verbose-upload")) {
                this.doVerboseUpload = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--useprogrammer")) {
                this.doUseProgrammer = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--nouploadport")) {
                this.noUploadPort = true;
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--board")) {
                if (++i >= stringArray.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --board"), 3);
                }
                this.processBoardArgument(stringArray[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--port")) {
                if (++i >= stringArray.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --port"), 3);
                }
                BaseNoGui.selectSerialPort(stringArray[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--curdir")) {
                if (++i < stringArray.length) continue;
                BaseNoGui.showError(null, I18n._("Argument required for --curdir"), 3);
                continue;
            }
            if (stringArray[i].equals("--buildpath")) {
                if (++i >= stringArray.length) {
                    BaseNoGui.showError(null, "Argument required for --buildpath", 3);
                }
                if (!((File)(object = new File(stringArray[i]))).exists()) {
                    BaseNoGui.showError(null, "The build path doesn't exist", 3);
                }
                if (!((File)object).isDirectory()) {
                    BaseNoGui.showError(null, "The build path is not a folder", 3);
                }
                BaseNoGui.setBuildFolder((File)object);
                continue;
            }
            if (stringArray[i].equals("--pref")) {
                if (++i >= stringArray.length) {
                    BaseNoGui.showError(null, I18n._("Argument required for --pref"), 3);
                }
                this.processPrefArgument(stringArray[i]);
                if (this.action != ACTION.GUI) continue;
                this.action = ACTION.NOOP;
                continue;
            }
            if (stringArray[i].equals("--save-prefs")) {
                this.forceSavePrefs = true;
                continue;
            }
            if (stringArray[i].equals("--preferences-file")) {
                if (++i < stringArray.length) continue;
                BaseNoGui.showError(null, I18n._("Argument required for --preferences-file"), 3);
                continue;
            }
            if (stringArray[i].startsWith("--")) {
                BaseNoGui.showError(null, I18n.format(I18n._("unknown option: {0}"), stringArray[i]), 3);
            }
            this.filenames.add(stringArray[i]);
        }
    }

    private void checkAction() {
        if ((this.action == ACTION.UPLOAD || this.action == ACTION.VERIFY) && this.filenames.size() != 1) {
            BaseNoGui.showError(null, I18n._("Must specify exactly one sketch file"), 3);
        }
        if ((this.action == ACTION.NOOP || this.action == ACTION.GET_PREF) && this.filenames.size() != 0) {
            BaseNoGui.showError(null, I18n._("Cannot specify any sketch files"), 3);
        }
        if (this.action != ACTION.UPLOAD && this.action != ACTION.VERIFY && (this.doVerboseBuild || this.doVerboseUpload)) {
            BaseNoGui.showError(null, I18n._("--verbose, --verbose-upload and --verbose-build can only be used together with --verify or --upload"), 3);
        }
    }

    private void processBoardArgument(String string) {
        TargetBoard targetBoard;
        TargetPlatform targetPlatform;
        TargetPackage targetPackage;
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(":", 4);
        if (stringArray.length < 3) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid board name, it should be of the form \"package:arch:board\" or \"package:arch:board:options\""), string), 3);
        }
        if ((targetPackage = BaseNoGui.getTargetPackage(stringArray[0])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown package"), stringArray[0]), 3);
        }
        if ((targetPlatform = targetPackage.get(stringArray[1])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown architecture"), stringArray[1]), 3);
        }
        if ((targetBoard = targetPlatform.getBoard(stringArray[2])) == null) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Unknown board"), stringArray[2]), 3);
        }
        BaseNoGui.selectBoard(targetBoard);
        if (stringArray.length > 3) {
            String[] stringArray2;
            for (String string2 : stringArray2 = stringArray[3].split(",")) {
                String[] stringArray3 = string2.split("=", 2);
                if (stringArray3.length != 2) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option, should be of the form \"name=value\""), string2, targetBoard.getId()), 3);
                }
                String string3 = stringArray3[0].trim();
                String string4 = stringArray3[1].trim();
                if (!targetBoard.hasMenu(string3)) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option for board \"{1}\""), string3, targetBoard.getId()), 3);
                }
                if (targetBoard.getMenuLabel(string3, string4) == null) {
                    BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid option for \"{1}\" option for board \"{2}\""), string4, string3, targetBoard.getId()), 3);
                }
                PreferencesData.set("custom_" + string3, targetBoard.getId() + "_" + string4);
            }
        }
    }

    private void processPrefArgument(String string) {
        String[] stringArray = string.split("=", 2);
        if (stringArray.length != 2 || stringArray[0].isEmpty()) {
            BaseNoGui.showError(null, I18n.format(I18n._("{0}: Invalid argument to --pref, should be of the form \"pref=value\""), string), 3);
        }
        PreferencesData.set(stringArray[0], stringArray[1]);
    }

    public boolean isDoVerboseBuild() {
        return this.doVerboseBuild;
    }

    public boolean isDoVerboseUpload() {
        return this.doVerboseUpload;
    }

    public boolean isForceSavePrefs() {
        return this.forceSavePrefs;
    }

    public String getGetPref() {
        return this.getPref;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public boolean isGetPrefMode() {
        return this.action == ACTION.GET_PREF;
    }

    public boolean isGuiMode() {
        return this.action == ACTION.GUI;
    }

    public boolean isNoOpMode() {
        return this.action == ACTION.NOOP;
    }

    public boolean isUploadMode() {
        return this.action == ACTION.UPLOAD;
    }

    public boolean isVerifyMode() {
        return this.action == ACTION.VERIFY;
    }

    public boolean isVerifyOrUploadMode() {
        return this.isVerifyMode() || this.isUploadMode();
    }

    public boolean isDoUseProgrammer() {
        return this.doUseProgrammer;
    }

    public boolean isNoUploadPort() {
        return this.noUploadPort;
    }

    protected static enum ACTION {
        GUI,
        NOOP,
        VERIFY,
        UPLOAD,
        GET_PREF;

    }
}

