/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.CertificateConfigException;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.security.cert.CertificateRevokedException;

public class BadCertificateDialog {
    private static boolean _isHttps = false;

    public static void showDialog(CodeSource codeSource, AppInfo appInfo, Exception exception) {
        Certificate[] certificateArray = codeSource == null ? null : codeSource.getCertificates();
        String string = BadCertificateDialog.getMessage("security.badcert.caption");
        String string2 = BadCertificateDialog.getHttpsDialog() ? BadCertificateDialog.getMessage("security.badcert.https.text") : (exception instanceof CertificateConfigException ? BadCertificateDialog.getMessage("security.badcert.config.text") : BadCertificateDialog.getMessage("security.badcert.text"));
        if (Config.isJavaVersionAtLeast17()) {
            if (exception instanceof CertificateRevokedException) {
                string2 = BadCertificateDialog.getMessage("security.badcert.revoked.text");
            }
            if (exception instanceof BlockedException) {
                string2 = BadCertificateDialog.getMessage("security.badcert.blocked.text");
            }
        }
        if (!Trace.isAutomationEnabled()) {
            ToolkitStore.getUI().showExceptionDialog(null, appInfo, exception, string, string2, null, certificateArray);
        } else {
            Trace.msgSecurityPrintln("trustdecider.automation.badcert");
        }
    }

    private static String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    private static int getAcceleratorKey(String string) {
        return ResourceManager.getAcceleratorKey(string);
    }

    private static boolean getHttpsDialog() {
        return _isHttps;
    }

    public static void setHttpsDialog(boolean bl) {
        _isHttps = bl;
    }
}

