/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.Environment;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.ConfigTrustManager;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.SyncFileAccess;
import com.sun.deploy.util.VersionID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import sun.net.www.protocol.https.Handler;

public class ClientConfig
extends Config {
    private boolean _configOK = false;
    private Properties _systemProps;
    private Properties _internalProps;
    private Properties _lockedProps;
    protected Properties _changedProps;
    private boolean _userConfigStore;
    protected boolean _dirty;
    private File _userConfigFile;
    private SyncFileAccess _userConfigFileSyncAccess;
    private String _enterprizeConfig = null;
    private long _lastChanged;
    private long _sysPropsModified = 0L;
    private static final String[] UNCACHABLE_PROPS = new String[]{"deployment.javaws.viewer.bounds"};
    private String initVersionOverride = null;

    public ClientConfig() {
        PerfLogger.setTime("Start Client Config Constructor");
        this.init(null, null);
        PerfLogger.setTime("End Client Config Constructor");
    }

    public Object setProperty(String string, String string2) {
        if (this.isDiskNewer()) {
            this.refreshIfNeeded();
        }
        String string3 = super.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            if (this.containsKey(string) && !this.isInternalProp(string)) {
                this._dirty = true;
            }
            this.remove(string);
            this._changedProps.remove(string);
        } else if (!string2.equals(string3)) {
            if (!this.isInternalProp(string)) {
                this._dirty = true;
            }
            super.setProperty(string, string2);
            this._changedProps.setProperty(string, string2);
        }
        return string3;
    }

    public boolean init(String string, String string2) {
        String string3;
        String string4;
        Object object;
        String string5;
        Object object2;
        Serializable serializable;
        PerfLogger.setTime("Start ClientConfig.init");
        boolean bl = true;
        String string6 = SecurityBaseline.getDeployNoBuildVersion();
        this._systemProps = new Properties();
        long l = 0L;
        this._internalProps = this.getInternalProps();
        this._changedProps = new Properties();
        this._userConfigStore = false;
        if (string == null) {
            this._userConfigFile = new File(ClientConfig.getUserPropertiesFile());
            this._userConfigStore = true;
        } else if (!string.equals("")) {
            this._userConfigFile = new File(string);
            if (!this._userConfigFile.exists()) {
                this._userConfigFile = null;
                Trace.println("Test user config file given: " + string + " is non existant", TraceLevel.BASIC);
            }
        } else {
            this._userConfigFile = null;
        }
        if (this._userConfigFile != null) {
            this._userConfigFileSyncAccess = new SyncFileAccess(this._userConfigFile);
        }
        PerfLogger.setTime("  - Start load system properties");
        if (string2 == null) {
            boolean bl2 = false;
            serializable = new File(ClientConfig.getSystemHome() + File.separator + "deployment.config");
            if (!((File)serializable).exists()) {
                serializable = new File(Environment.getDeploymentHomePath() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (!((File)serializable).exists()) {
                serializable = new File(Environment.getJavaHome() + File.separator + "lib" + File.separator + "deployment.config");
            }
            if (((File)serializable).exists() && (object2 = this.loadPropertiesFile(new Properties(), (File)serializable)) != null) {
                string5 = ((Properties)object2).getProperty("deployment.system.config.mandatory");
                bl2 = string5 != null && !string5.equalsIgnoreCase("false");
                object = ((Properties)object2).getProperty("deployment.system.config");
                this._enterprizeConfig = object;
            }
            if (!this.initializeSysProps(this._enterprizeConfig, this._systemProps)) {
                bl = !bl2;
            }
        } else {
            bl = true;
            if (!string2.equals("")) {
                File file = new File(string2);
                if (file.exists()) {
                    this.loadPropertiesFile(this._systemProps, file);
                } else {
                    Trace.println("Test system config file given: " + string2 + " is non existant", TraceLevel.BASIC);
                }
            }
        }
        PerfLogger.setTime("  - End load system properties");
        Properties properties = this.refreshProperties();
        PerfLogger.setTime("  - End refreshProperties");
        this.versionUpdateCheck();
        PerfLogger.setTime("  - end VersionUpdateCheck");
        serializable = System.getProperties();
        PerfLogger.setTime("  - end getting all system properties");
        object2 = this.propertyNames();
        while (object2.hasMoreElements()) {
            string5 = (String)object2.nextElement();
            object = this.getProperty(string5);
            if (object == null) continue;
            ((Properties)serializable).put(string5, ClientConfig.replaceVariables((String)object));
        }
        System.setProperties((Properties)serializable);
        PerfLogger.setTime("  - end setting all system properties");
        this.setPolicyFiles();
        if (this._userConfigFile != null) {
            for (int i = 0; i < PROXY_KEYS.length; ++i) {
                object = PROXY_KEYS[i];
                string4 = "active." + (String)object;
                this.setProperty(string4, this.getProperty((String)object));
            }
        }
        if ((string5 = this.getProperty("deployment.webjava.enabled")) != null && !Boolean.valueOf(string5).booleanValue() && Environment.isWebJava()) {
            bl = false;
        }
        if (this._systemProps != null) {
            object = this._systemProps.keys();
            while (object.hasMoreElements()) {
                string4 = (String)object.nextElement();
                string3 = this._systemProps.getProperty(string4);
                if (string3 == null || string3.equals(properties.get(string4))) continue;
                this._dirty = true;
                break;
            }
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(this.getProperty("deployment.modified.timestamp"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._sysPropsModified > l2 && this._systemProps.containsKey("deployment.webjava.enabled")) {
            this.setProperty("deployment.webjava.enabled", this._systemProps.getProperty("deployment.webjava.enabled"));
        }
        string3 = null;
        if (properties != null && properties.containsKey("deployment.expiration.check.enabled")) {
            string3 = properties.getProperty("deployment.expiration.check.enabled");
        }
        if (this._systemProps != null && this._systemProps.containsKey("deployment.expiration.check.enabled")) {
            string3 = this._systemProps.getProperty("deployment.expiration.check.enabled");
        }
        if (string3 != null) {
            ClientConfig.setExpirationCheckEnabled(Boolean.valueOf(string3));
        }
        if (SecurityBaseline.isExpired()) {
            this._dirty = true;
        }
        this.storeIfNeeded();
        PerfLogger.setTime("End Config.init");
        this._configOK = bl;
        return bl;
    }

    private Properties refreshProperties() {
        String string;
        String string2;
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        Properties properties3 = new Properties();
        Properties properties4 = new Properties();
        Properties properties5 = new Properties();
        this._lockedProps = new Properties();
        this.clear();
        this.putAll((Map<?, ?>)ClientConfig.getDefaults());
        if (this._userConfigFile == null) {
            properties.clear();
        } else if (this._userConfigFile.exists()) {
            PerfLogger.setTime("Start loadPropertiesFile");
            this.loadPropertiesFile(properties, this._userConfigFile);
            PerfLogger.setTime("End loadPropertiesFile");
            this._lastChanged = this._userConfigFile.lastModified();
        } else {
            this._lastChanged = System.currentTimeMillis();
        }
        Enumeration<Object> enumeration = this._systemProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = this._systemProps.getProperty(string2);
            if (string2.startsWith("deployment.javaws.jre.")) {
                properties3.setProperty(string2, string);
                continue;
            }
            if (string2.endsWith(".locked")) {
                int n = string2.length() - ".locked".length();
                String string3 = this._systemProps.getProperty(string2 = string2.substring(0, n));
                if (string3 == null) continue;
                this.lockProperty(string2, string3);
                continue;
            }
            if (!string2.startsWith("deployment.")) continue;
            this.setProperty(string2, string);
        }
        enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            string = properties.getProperty(string2);
            if (string2.startsWith("deployment.javaws.jre.")) {
                properties2.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith("deployment.javapi.jre.")) {
                properties4.setProperty(string2, string);
                continue;
            }
            if (string2.startsWith("deployment.javapi.jdk.")) {
                properties5.setProperty(string2, string);
                continue;
            }
            if (!string2.startsWith("deployment.") && !string2.startsWith("javaplugin")) continue;
            this.setProperty(string2, string);
        }
        PerfLogger.setTime(" - Start JREInfo.initialize");
        JREInfo.initialize(properties3, properties2);
        PerfLogger.setTime(" - End JREInfo.initialize");
        JREInfo.importJpiEntries(properties4);
        PerfLogger.setTime(" - end importing JPI entries");
        this.getInternalPropValues();
        enumeration = this._lockedProps.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            this.setProperty(string2, this._lockedProps.getProperty(string2));
        }
        this._dirty = false;
        this._changedProps.clear();
        return properties;
    }

    public void getInternalPropValues() {
        if (ClientConfig.getOSName().equals("Windows")) {
            if (Platform.get().isPlatformWindowsVista() || !Platform.get().hasAdminPrivileges()) {
                this.lockProperty("deployment.browser.vm.iexplorer", new Boolean(true).toString());
            } else {
                this.unlockProperty("deployment.browser.vm.iexplorer");
            }
            String string = this.getProperty("deployment.browser.vm.mozilla");
            if (!Platform.get().hasAdminPrivileges()) {
                this.lockProperty("deployment.browser.vm.mozilla", string);
            } else {
                this.unlockProperty("deployment.browser.vm.mozilla");
            }
            Collection collection = Platform.get().getInstalledJfxRuntimes(true);
            if (collection.isEmpty()) {
                this.lockProperty("deployment.javafx.mode.enabled", this.getProperty("deployment.javafx.mode.enabled"));
            } else {
                this.unlockProperty("deployment.javafx.mode.enabled");
            }
        }
        if (this._userConfigFile != null) {
            this.getJavaPlugin();
            this.getJqs();
        }
    }

    private void setPolicyFiles() {
        String string;
        String string2 = this.getProperty("deployment.system.security.policy");
        if (string2 != null) {
            string2 = ClientConfig.replaceVariables(string2).trim();
        }
        if ((string = this.getProperty("deployment.user.security.policy")) != null) {
            string = ClientConfig.replaceVariables(string).trim();
        }
        if (string2 != null || string != null) {
            int n = 1;
            String string3 = null;
            while ((string3 = Security.getProperty("policy.url." + n)) != null) {
                ++n;
            }
            if (string2 != null) {
                Security.setProperty("policy.url." + n, string2);
                ++n;
            }
            if (string != null) {
                Security.setProperty("policy.url." + n, string);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDownloading(String string, Properties properties) {
        URLConnection uRLConnection = null;
        try {
            URL uRL = null;
            uRL = string.toLowerCase().startsWith("https:") ? new URL(null, string, new Handler()) : new URL(string);
            uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpsURLConnection) {
                ConfigTrustManager.resetHttpsFactory((HttpsURLConnection)uRLConnection);
            }
            InputStream inputStream = uRLConnection.getInputStream();
            properties.load(inputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Trace.ignoredException(exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (uRLConnection != null && uRLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)uRLConnection).disconnect();
            }
        }
    }

    private boolean initializeSysProps(String string, Properties properties) {
        File file;
        boolean bl = true;
        if (string != null) {
            bl = this.tryDownloading(string, properties);
        }
        if (!(file = new File(ClientConfig.getSystemHome() + File.separator + ClientConfig.getPropertiesFilename())).exists()) {
            file = new File(Environment.getJavaHome() + File.separator + "lib" + File.separator + ClientConfig.getPropertiesFilename());
        }
        if (file.exists()) {
            this._sysPropsModified = file.lastModified();
            this.loadPropertiesFile(properties, file);
        }
        return bl;
    }

    public void refreshUnchangedProps() {
        Properties properties = this._changedProps;
        this.refreshProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    public boolean isDiskNewer() {
        return this._userConfigFile != null && this._userConfigFile.exists() && this._userConfigFile.lastModified() > this._lastChanged;
    }

    private static boolean isPropertyCachable(String string) {
        for (int i = 0; i < UNCACHABLE_PROPS.length; ++i) {
            if (!UNCACHABLE_PROPS[i].equals(string)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidExpiredDecisionKey(String string) {
        if (string.equals("deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion())) {
            return true;
        }
        if (string.equals("deployment.expiration.decision.timestamp." + SecurityBaseline.getDeployNoBuildVersion())) {
            return true;
        }
        if (string.equals("deployment.expiration.decision.suppression." + SecurityBaseline.getDeployNoBuildVersion())) {
            return true;
        }
        return string.equals("deployment.expiration.decision.ttl." + SecurityBaseline.getDeployNoBuildVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeConfig() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Properties properties;
        if (!this._userConfigStore) {
            return;
        }
        if (this._dirty && this.isDiskNewer()) {
            properties = this._changedProps;
            this.refreshProperties();
            object4 = properties.keys();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                this.setProperty((String)object3, properties.getProperty((String)object3));
            }
        }
        if ((properties = Platform.get().getPendingConfigProperties()) != null) {
            object4 = "deployment.webjava.enabled";
            object3 = properties.getProperty((String)object4);
            if (object3 != null) {
                this.setProperty((String)object4, (String)object3);
            }
            if ((object3 = properties.getProperty((String)(object4 = "deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion()))) != null) {
                this.setProperty((String)object4, (String)object3);
            }
            if ((object3 = properties.getProperty((String)(object4 = "deployment.expiration.decision.timestamp." + SecurityBaseline.getDeployNoBuildVersion()))) != null) {
                this.setProperty((String)object4, (String)object3);
            }
            if ((object3 = properties.getProperty((String)(object4 = "deployment.expiration.decision.suppression." + SecurityBaseline.getDeployNoBuildVersion()))) != null) {
                this.setProperty((String)object4, (String)object3);
            }
        }
        object4 = new Properties();
        object3 = new Properties();
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            String string = this.getProperty((String)object2);
            String string2 = this._systemProps.getProperty((String)object2);
            object = ClientConfig.getDefaults().getProperty((String)object2);
            if (this.isInternalProp((String)object2) || ((String)object2).startsWith("deployment.expiration.decision.") && !ClientConfig.isValidExpiredDecisionKey((String)object2)) continue;
            if (!this.isPropertyLocked((String)object2) && (string == null || string2 != null && !string.equals(string2) || string2 == null && !string.equals(object))) {
                ((Properties)object4).setProperty((String)object2, string);
            }
            if (string != null && string.equals(object) || !ClientConfig.isPropertyCachable((String)object2)) continue;
            properties2.setProperty((String)object2, string);
        }
        object2 = JREInfo.getAll();
        int n = 0;
        for (int i = 0; i < ((JREInfo[])object2).length; ++i) {
            if (object2[i].isSystemJRE() || Environment.isForcedJreRoot(object2[i].getPath())) continue;
            if (((JREInfo)object2[i]).getPlatform() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".platform", ((JREInfo)object2[i]).getPlatform());
            }
            if (((JREInfo)object2[i]).getProduct() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".product", ((JREInfo)object2[i]).getProduct());
            }
            if (((JREInfo)object2[i]).getLocation() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".location", ((JREInfo)object2[i]).getLocation());
            }
            if (((JREInfo)object2[i]).getPath() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".path", ((JREInfo)object2[i]).getPath());
            }
            if (((JREInfo)object2[i]).getVmArgs() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".args", ((JREInfo)object2[i]).getVmArgs());
            }
            if (((JREInfo)object2[i]).getOSArch() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".osarch", ((JREInfo)object2[i]).getOSArch());
            }
            if (((JREInfo)object2[i]).getOSName() != null) {
                ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".osname", ((JREInfo)object2[i]).getOSName());
            }
            ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".enabled", ClientConfig.booleanToString(((JREInfo)object2[i]).isEnabled()));
            ((Properties)object3).setProperty("deployment.javaws.jre." + n + ".registered", ClientConfig.booleanToString(((JREInfo)object2[i]).isRegistered()));
            ++n;
        }
        this._userConfigFile.getParentFile().mkdirs();
        try {
            ((Properties)object4).setProperty("deployment.modified.timestamp", new Long(System.currentTimeMillis()).toString());
            SyncFileAccess.FileOutputStreamLock fileOutputStreamLock = this._userConfigFileSyncAccess.openLockFileOutputStream(false, 2000, false);
            object = fileOutputStreamLock != null ? fileOutputStreamLock.getFileOutputStream() : new FileOutputStream(this._userConfigFile);
            try {
                if (object != null) {
                    try {
                        ((Properties)object4).store((OutputStream)object, ClientConfig.getPropertiesFilename());
                        ((Properties)object3).store((OutputStream)object, "Java Deployment jre's");
                    }
                    catch (IOException iOException) {
                        Trace.println("Exception: " + iOException, TraceLevel.BASIC);
                    }
                }
            }
            finally {
                if (object != null) {
                    ((OutputStream)object).flush();
                    try {
                        ((FileOutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStreamLock != null) {
                    fileOutputStreamLock.release();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._dirty = false;
        this._changedProps.clear();
        if (SecurityBaseline.isExpired()) {
            properties2.setProperty("deployment.expired.version", SecurityBaseline.getDeployNoBuildVersion());
        }
        Platform.get().cacheCurrentConfig(properties2);
        this._lastChanged = this._userConfigFile.exists() ? this._userConfigFile.lastModified() : System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFile(Properties properties, File file) {
        SyncFileAccess.FObjLock fObjLock = null;
        FileInputStream fileInputStream = null;
        try {
            fObjLock = file.equals(this._userConfigFile) ? this._userConfigFileSyncAccess.openLockFileInputStream(1000, false) : null;
            fileInputStream = fObjLock != null ? ((SyncFileAccess.FileInputStreamLock)fObjLock).getFileInputStream() : new FileInputStream(file);
            properties.load(fileInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.println("Cannot find prop file: " + file.getAbsolutePath(), TraceLevel.BASIC);
            Properties properties3 = null;
            return properties3;
        }
        catch (IOException iOException) {
            Trace.println("IO Execption: " + iOException, TraceLevel.BASIC);
            Properties properties4 = null;
            return properties4;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fObjLock != null) {
                fObjLock.release();
            }
        }
    }

    private Properties getInternalProps() {
        Properties properties = new Properties();
        properties.setProperty("java.quick.starter", "false");
        properties.setProperty("deployment.browser.vm.iexplorer", "true");
        properties.setProperty("deployment.browser.vm.mozilla", "true");
        properties.setProperty("deployment.javafx.mode.enabled", "true");
        properties.setProperty("deployment.jpi.mode.new", "true");
        return properties;
    }

    public boolean isInternalProp(String string) {
        return this._internalProps.containsKey(string) || string.startsWith("active.");
    }

    void setInitVersionOverride(String string) {
        this.initVersionOverride = string;
    }

    private void versionUpdateCheck() {
        Object object;
        VersionID versionID;
        String string;
        String string2 = string = this.initVersionOverride == null ? "7.21" : this.initVersionOverride;
        if (this._userConfigStore) {
            string = this.getProperty("deployment.version");
        }
        VersionID versionID2 = versionID = string == null ? null : new VersionID(string);
        if (versionID == null || new VersionID("1.5.0").isGreaterThan(versionID)) {
            String string3;
            Object object2;
            object = this.translateMantisProperties(this);
            if (((Properties)object).getProperty("deployment.javaws.cachedir") == null && new File((String)(object2 = ClientConfig.getUserHome() + File.separator + "javaws" + File.separator + "cache")).exists()) {
                ((Properties)object).setProperty("deployment.javaws.cachedir", (String)object2);
            }
            object2 = null;
            File file = new File(ClientConfig.getUserHome());
            String string4 = file.getParent() + File.separator + ".deployment";
            String string5 = string4 + File.separator + "deployment.properties";
            File file2 = new File(string5);
            if (file2.exists() && ((Properties)(object2 = this.translateMantisProperties(this.loadPropertiesFile(new Properties(), file2)))).getProperty("deployment.javaws.cachedir") == null && new File(string3 = string4 + File.separator + "javaws" + File.separator + "cache").exists()) {
                ((Properties)object2).setProperty("deployment.javaws.cachedir", string3);
            }
            if (object2 != null) {
                this.setProperties((Properties)object2);
            }
            if (object != null) {
                this.setProperties((Properties)object);
            }
            this.setProperty("deployment.browser.path", Platform.get().getBrowserPath());
            versionID = new VersionID("1.5.0");
        }
        if (new VersionID("6.0").isGreaterThan(versionID)) {
            this.setProperties(this.translateTigerProperties(this));
            ClientConfig.setBooleanProperty("deployment.javaws.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.javapi.cache.update", true);
            ClientConfig.setBooleanProperty("deployment.capture.mime.types", true);
        }
        if (new VersionID("7.0").isGreaterThan(versionID)) {
            // empty if block
        }
        if (new VersionID("7.21").isGreaterThan(versionID) && !this._systemProps.containsKey("deployment.security.level") && !"HIGH".equals(object = this.getProperty("deployment.security.level")) && !"VERY_HIGH".equals(object)) {
            this.setProperty("deployment.security.level", "HIGH");
        }
        this.setProperty("deployment.version", "7.21");
    }

    private void setProperties(Properties properties) {
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.setProperty(string, properties.getProperty(string));
        }
    }

    private Properties translateMantisProperties(Properties properties) {
        String string;
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string2 = null;
            String string3 = properties.getProperty(string);
            if (string.startsWith("deployment.javaws.proxy")) {
                if (string.equals("deployment.javaws.proxy.httpport")) {
                    string2 = "deployment.proxy.http.port";
                } else if (string.equals("deployment.javaws.proxy.http")) {
                    string2 = "deployment.proxy.http.host";
                } else if (string.equals("deployment.javaws.proxy.httpproxyoverride")) {
                    string2 = "deployment.proxy.override.hosts";
                }
            } else if (string.startsWith("deployment.javaws.")) {
                if (string.equals("deployment.javaws.logFileName")) {
                    string2 = "deployment.javaws.traceFileName";
                } else if (string.equals("deployment.javaws.showConsole")) {
                    if (string3.equals("true")) {
                        string2 = "deployment.console.startup.mode";
                        string3 = "SHOW";
                    }
                } else if (string.equals("deployment.javaws.updateTimeout")) {
                    string2 = "deployment.javaws.update.timeout";
                } else if (string.equals("deployment.javaws.version")) {
                    string3 = null;
                }
            } else if (string.startsWith("javaplugin")) {
                properties2.setProperty(string, string3);
                if (string.equals("javaplugin.cache.disabled")) {
                    string2 = "deployment.cache.enabled";
                    string3 = string3.equals("true") ? "false" : "true";
                } else if (string.equals("javaplugin.cache.size")) {
                    string2 = "deployment.cache.max.size";
                } else if (string.equals("javaplugin.cache.compression")) {
                    string2 = "deployment.cache.jarcompression";
                } else if (string.equals("javaplugin.console")) {
                    string2 = "deployment.console.startup.mode";
                    string3 = string3.equals("show") ? "SHOW" : (string3.equals("hide") ? "HIDE" : "DISABLE");
                } else if (string.equals("javaplugin.exception")) {
                    string2 = "deployment.javapi.lifecycle.exception";
                }
            }
            if (string2 == null || string3 == null || string3.length() <= 0) continue;
            properties2.setProperty(string2, string3);
        }
        string = properties.getProperty("deployment.javaws.cache.dir");
        if (string != null) {
            properties2.setProperty("deployment.javaws.cachedir", string);
        }
        return properties2;
    }

    private Properties translateTigerProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.equals("deployment.javaws.associations") && (string2.equals("NEW_ONLY") || string2.equals("REPLACE_ASK"))) {
                string2 = "ASK_USER";
            }
            properties2.setProperty(string, string2);
        }
        return properties2;
    }

    public boolean getJavaPlugin() {
        boolean bl = true;
        if (ClientConfig.getOSArch().equalsIgnoreCase("amd64")) {
            this.lockProperty("deployment.jpi.mode.new", "true");
            bl = true;
        } else {
            bl = Platform.get().getJavaPluginSettings();
            if (!Platform.get().canBecomeAdmin()) {
                this.lockProperty("deployment.jpi.mode.new", new Boolean(bl).toString());
            } else {
                this.unlockProperty("deployment.jpi.mode.new");
            }
        }
        this.setProperty("deployment.jpi.mode.new", new Boolean(bl).toString());
        return bl;
    }

    public boolean getJqs() {
        boolean bl = Platform.get().getJqsSettings();
        if (Platform.get().isPlatformWindowsVista()) {
            this.lockProperty("java.quick.starter", "false");
        } else {
            this.unlockProperty("java.quick.starter");
        }
        this.setProperty("java.quick.starter", new Boolean(bl).toString());
        return bl;
    }

    void lockProperty(String string, String string2) {
        if (this._lockedProps == null) {
            this._lockedProps = new Properties();
        }
        this._lockedProps.setProperty(string, string2);
    }

    void unlockProperty(String string) {
        if (this._lockedProps != null) {
            this._lockedProps.remove(string);
        }
    }

    public boolean isPropertyLocked(String string) {
        if (this._lockedProps == null) {
            return false;
        }
        return this._lockedProps.containsKey(string);
    }

    public void storeIfNeeded() {
        if (this._dirty) {
            this.storeConfig();
        }
    }

    public void refreshIfNeeded() {
        if (!this._dirty && this.isDiskNewer()) {
            this.refreshProperties();
        }
    }

    public void storeInstalledJREs(Vector vector) {
        this._dirty |= JREInfo.setInstalledJREList(vector);
        this.storeIfNeeded();
    }

    public String getEnterpriseString() {
        return this._enterprizeConfig;
    }

    public boolean isValid() {
        return this._configOK;
    }

    public boolean isConfigDirty() {
        return this._dirty;
    }

    public Properties getSystemProps() {
        return this._systemProps;
    }
}

