/*
 * Decompiled with CFR 0.152.
 */
package processing.app.linux;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import processing.app.PreferencesData;
import processing.app.debug.TargetPackage;
import processing.app.legacy.PConstants;
import processing.app.linux.UDevAdmParser;
import processing.app.tools.ExternalProcessExecutor;

public class Platform
extends processing.app.Platform {
    @Override
    public void setLookAndFeel() throws Exception {
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        File file = new File(System.getProperty("user.home"));
        return new File(file, "Arduino");
    }

    @Override
    public void openURL(String string) throws Exception {
        String string2;
        if (this.openFolderAvailable() && (string2 = PreferencesData.get("launcher")) != null) {
            Runtime.getRuntime().exec(new String[]{string2, string});
        }
    }

    @Override
    public boolean openFolderAvailable() {
        if (PreferencesData.get("launcher") != null) {
            return true;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"xdg-open"});
            process.waitFor();
            PreferencesData.set("launcher", "xdg-open");
            return true;
        }
        catch (Exception exception) {
            try {
                Process process = Runtime.getRuntime().exec(new String[]{"gnome-open"});
                process.waitFor();
                PreferencesData.set("launcher", "gnome-open");
                return true;
            }
            catch (Exception exception2) {
                try {
                    Process process = Runtime.getRuntime().exec(new String[]{"kde-open"});
                    process.waitFor();
                    PreferencesData.set("launcher", "kde-open");
                    return true;
                }
                catch (Exception exception3) {
                    return false;
                }
            }
        }
    }

    @Override
    public void openFolder(File file) throws Exception {
        if (this.openFolderAvailable()) {
            String string = PreferencesData.get("launcher");
            try {
                String[] stringArray = new String[]{string, file.getAbsolutePath()};
                Runtime.getRuntime().exec(stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println("No launcher set, cannot open " + file.getAbsolutePath());
        }
    }

    @Override
    public String getName() {
        return PConstants.platformNames[3];
    }

    @Override
    public String resolveDeviceAttachedTo(String string, Map<String, TargetPackage> map, String string2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ExternalProcessExecutor externalProcessExecutor = new ExternalProcessExecutor(byteArrayOutputStream);
        try {
            CommandLine commandLine = CommandLine.parse((String)("udevadm info -q path -n " + string));
            externalProcessExecutor.execute(commandLine);
            String string3 = new String(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
            CommandLine commandLine2 = CommandLine.parse((String)("udevadm info --query=property -p " + string3));
            externalProcessExecutor.execute(commandLine2);
            String string4 = new UDevAdmParser().extractVIDAndPID(new String(byteArrayOutputStream.toByteArray()));
            if (string4 == null) {
                return super.resolveDeviceAttachedTo(string, map, string2);
            }
            return super.resolveDeviceByVendorIdProductId(map, string4);
        }
        catch (IOException iOException) {
            return super.resolveDeviceAttachedTo(string, map, string2);
        }
    }
}

