/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class FileUtils {
    private static final List<String> SOURCE_CONTROL_FOLDERS = Arrays.asList("CVS", "RCS", ".git", ".svn", ".hg", ".bzr");
    private static final Pattern BACKSLASH = Pattern.compile("\\\\");

    public static boolean isSubDirectory(File file, File file2) {
        try {
            file = file.getCanonicalFile();
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        for (File file3 = file2; file3 != null; file3 = file3.getParentFile()) {
            if (!file.equals(file3)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            int n = -1;
            while ((n = fileInputStream.read(byArray, 0, byArray.length)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        for (File file3 : file.listFiles()) {
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                if (!file4.mkdir()) {
                    throw new IOException("Unable to create folder: " + file4);
                }
                FileUtils.copy(file3, file4);
                continue;
            }
            FileUtils.copyFile(file3, file4);
        }
    }

    public static void recursiveDelete(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtils.recursiveDelete(file2);
            }
        }
        file.delete();
    }

    public static File createTempFolder() throws IOException {
        File file = new File(System.getProperty("java.io.tmpdir"), "arduino_" + new Random().nextInt(1000000));
        if (!file.mkdir()) {
            throw new IOException("Unable to create temp folder " + file);
        }
        return file;
    }

    public static String relativePath(String object, String string) {
        Object object2;
        try {
            object = new File((String)object).getCanonicalPath();
            object2 = new File(string);
            string = ((File)object2).isAbsolute() ? ((File)object2).getCanonicalPath() : new File((String)object, string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        if (((String)object).equals(string)) {
            return ".";
        }
        if (((String)object).equals(File.separator)) {
            return "." + string;
        }
        object2 = "";
        String string2 = File.separator;
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            if (((String)object).startsWith("\\\\") || string.startsWith("\\\\")) {
                return null;
            }
            char c = ((String)object).charAt(0);
            char c2 = string.charAt(0);
            if (Character.isLetter(c) && Character.isLetter(c2) && c != c2) {
                return null;
            }
            object2 = "" + c + ':';
            string2 = (String)object2 + File.separator;
        }
        String string3 = "";
        while (!string.startsWith((String)object + File.separator)) {
            if (((String)(object = new File((String)object).getParent())).equals(string2)) {
                object = object2;
            }
            string3 = string3 + "..";
            string3 = string3 + File.separator;
        }
        return string3 + string.substring(((String)object).length() + 1);
    }

    public static String getLinuxPathFrom(File file) {
        return BACKSLASH.matcher(file.getAbsolutePath()).replaceAll("/");
    }

    public static boolean isSCCSOrHiddenFile(File file) {
        return file.isHidden() || file.getName().charAt(0) == '.' || file.isDirectory() && SOURCE_CONTROL_FOLDERS.contains(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string).append("\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasExtension(File file, String ... stringArray) {
        return FileUtils.hasExtension(file, Arrays.asList(stringArray));
    }

    public static boolean hasExtension(File file, List<String> list) {
        String[] stringArray = file.getName().split("\\.");
        if (stringArray.length < 2) {
            return false;
        }
        String string = stringArray[stringArray.length - 1];
        return list.contains(string.toLowerCase());
    }

    public static List<File> listFiles(File file, boolean bl, String ... stringArray) {
        return FileUtils.listFiles(file, bl, Arrays.asList(stringArray));
    }

    public static List<File> listFiles(File file, boolean bl, List<String> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file2 : file.listFiles()) {
            if (FileUtils.isSCCSOrHiddenFile(file2)) continue;
            if (file2.isDirectory()) {
                if (!bl) continue;
                arrayList.addAll(FileUtils.listFiles(file2, true, list));
                continue;
            }
            if (!list.isEmpty() && !FileUtils.hasExtension(file2, list)) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }
}

