/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.I18n;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.PreferencesMap;

public class TargetPlatform {
    private String id;
    private File folder;
    private TargetPackage containerPackage;
    private Map<String, TargetBoard> boards = new LinkedHashMap<String, TargetBoard>();
    private TargetBoard defaultBoard;
    private Map<String, PreferencesMap> programmers = new LinkedHashMap<String, PreferencesMap>();
    private PreferencesMap preferences = new PreferencesMap();
    private PreferencesMap customMenus = new PreferencesMap();

    public TargetPlatform(String string, File file, TargetPackage targetPackage) throws TargetPlatformException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.id = string;
        this.folder = file;
        this.containerPackage = targetPackage;
        File file2 = new File(this.folder, "boards.txt");
        if (!file2.exists() || !file2.canRead()) {
            throw new TargetPlatformException(I18n.format(I18n._("Could not find boards.txt in {0}. Is it pre-1.5?"), this.folder.getAbsolutePath()));
        }
        try {
            object3 = new PreferencesMap(file2).firstLevelMap();
            serializable = object3.get("menu");
            if (serializable != null) {
                this.customMenus = ((PreferencesMap)serializable).topLevelMap();
            }
            object3.remove("menu");
            object2 = object3.keySet();
            object = object2.iterator();
            while (object.hasNext()) {
                String string2 = object.next();
                PreferencesMap preferencesMap = object3.get(string2);
                TargetBoard targetBoard = new TargetBoard(string2, preferencesMap, this);
                this.boards.put(string2, targetBoard);
                if (this.defaultBoard != null) continue;
                this.defaultBoard = targetBoard;
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), file2.getAbsolutePath()), iOException);
        }
        object3 = new File(this.folder, "platform.txt");
        try {
            if (((File)object3).exists() && ((File)object3).canRead()) {
                this.preferences.load((File)object3);
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)object3).getAbsolutePath()), iOException);
        }
        serializable = new File(this.folder, "platform.local.txt");
        try {
            if (((File)serializable).exists() && ((File)serializable).canRead()) {
                this.preferences.load((File)serializable);
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)serializable).getAbsolutePath()), iOException);
        }
        object2 = new File(this.folder, "programmers.txt");
        try {
            if (((File)object2).exists() && ((File)object2).canRead()) {
                object = new PreferencesMap();
                ((PreferencesMap)object).load((File)object2);
                this.programmers = ((PreferencesMap)object).firstLevelMap();
            }
        }
        catch (IOException iOException) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), ((File)object2).getAbsolutePath()), iOException);
        }
    }

    public String getId() {
        return this.id;
    }

    public File getFolder() {
        return this.folder;
    }

    public Map<String, TargetBoard> getBoards() {
        return this.boards;
    }

    public PreferencesMap getCustomMenus() {
        return this.customMenus;
    }

    public Set<String> getCustomMenuIds() {
        return this.customMenus.keySet();
    }

    public Map<String, PreferencesMap> getProgrammers() {
        return this.programmers;
    }

    public PreferencesMap getProgrammer(String string) {
        return this.getProgrammers().get(string);
    }

    public PreferencesMap getTool(String string) {
        return this.getPreferences().subTree("tools").subTree(string);
    }

    public PreferencesMap getPreferences() {
        return this.preferences;
    }

    public TargetBoard getBoard(String string) {
        if (this.boards.containsKey(string)) {
            return this.boards.get(string);
        }
        return this.defaultBoard;
    }

    public TargetPackage getContainerPackage() {
        return this.containerPackage;
    }

    public String toString() {
        String string = "TargetPlatform: name=" + this.id + " boards={\n";
        for (String string2 : this.boards.keySet()) {
            string = string + "  " + string2 + " = " + this.boards.get(string2) + "\n";
        }
        return string + "}";
    }
}

