/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.SocketException;
import processing.app.debug.MessageConsumer;

public class MessageSiphon
implements Runnable {
    private final Reader streamReader;
    private final MessageConsumer consumer;
    private Thread thread;
    private boolean canRun;
    private int lineTimeout;

    public MessageSiphon(InputStream inputStream, MessageConsumer messageConsumer) {
        this(inputStream, messageConsumer, 0);
    }

    public MessageSiphon(InputStream inputStream, MessageConsumer messageConsumer, int n) {
        this.streamReader = new InputStreamReader(inputStream);
        this.consumer = messageConsumer;
        this.canRun = true;
        this.lineTimeout = n;
        this.thread = new Thread(this);
        this.thread.setPriority(9);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            long l = 0L;
            while (this.canRun) {
                while (this.lineTimeout == 0 || stringBuilder.length() == 0 || this.streamReader.ready()) {
                    int n = this.streamReader.read();
                    if (n == -1) {
                        return;
                    }
                    if (!this.canRun) {
                        return;
                    }
                    if (stringBuilder.length() == 0) {
                        l = System.nanoTime();
                    }
                    stringBuilder.append((char)n);
                    if (n != 10) continue;
                    this.consumer.message(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                long l2 = (System.nanoTime() - l) / 1000L;
                if (l2 < (long)this.lineTimeout) {
                    Thread.sleep((long)this.lineTimeout - l2);
                    continue;
                }
                this.consumer.message(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SocketException socketException) {
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null && string.indexOf("Bad file descriptor") != -1) {
            } else {
                exception.printStackTrace();
            }
        }
        finally {
            this.thread = null;
        }
    }

    public void join() throws InterruptedException {
        Thread thread = this.thread;
        if (thread != null) {
            thread.join();
        }
    }

    public void stop() {
        this.canRun = false;
    }
}

