/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.helpers.FileUtils;

public class SketchCode {
    private String prettyName;
    private File file;
    private String program;
    private boolean modified;
    private int preprocOffset;
    private Object metadata;

    public SketchCode(File file) {
        this.init(file, null);
    }

    public SketchCode(File file, Object object) {
        this.init(file, object);
    }

    private void init(File file, Object object) {
        this.file = file;
        this.metadata = object;
        this.makePrettyName();
        try {
            this.load();
        }
        catch (IOException iOException) {
            System.err.println(I18n.format(I18n._("Error while loading code {0}"), file.getName()));
        }
    }

    protected void makePrettyName() {
        this.prettyName = this.file.getName();
        int n = this.prettyName.lastIndexOf(46);
        this.prettyName = this.prettyName.substring(0, n);
    }

    public File getFile() {
        return this.file;
    }

    protected boolean fileExists() {
        return this.file.exists();
    }

    protected boolean fileReadOnly() {
        return !this.file.canWrite();
    }

    protected boolean deleteFile(File file) {
        File[] fileArray;
        if (!this.file.delete()) {
            return false;
        }
        for (File file2 : fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(SketchCode.this.getFileName());
            }
        })) {
            file2.delete();
        }
        return true;
    }

    protected boolean renameTo(File file) {
        boolean bl = this.file.renameTo(file);
        if (bl) {
            this.file = file;
            this.makePrettyName();
        }
        return bl;
    }

    protected void copyTo(File file) throws IOException {
        BaseNoGui.saveFile(this.program, file);
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public boolean isExtension(String ... stringArray) {
        return this.isExtension(Arrays.asList(stringArray));
    }

    public boolean isExtension(List<String> list) {
        return FileUtils.hasExtension(this.file, list);
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String string) {
        this.program = string;
    }

    public int getLineCount() {
        return BaseNoGui.countLines(this.program);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setPreprocOffset(int n) {
        this.preprocOffset = n;
    }

    public int getPreprocOffset() {
        return this.preprocOffset;
    }

    public void addPreprocOffset(int n) {
        this.preprocOffset += n;
    }

    public void load() throws IOException {
        this.program = BaseNoGui.loadFile(this.file);
        if (this.program.indexOf(65533) != -1) {
            System.err.println(I18n.format(I18n._("\"{0}\" contains unrecognized characters.If this code was created with an older version of Arduino,you may need to use Tools -> Fix Encoding & Reload to updatethe sketch to use UTF-8 encoding. If not, you may need todelete the bad characters to get rid of this warning."), this.file.getName()));
            System.err.println();
        }
        this.setModified(false);
    }

    public void save() throws IOException {
        BaseNoGui.saveFile(this.program, this.file);
        this.setModified(false);
    }

    public void saveAs(File file) throws IOException {
        BaseNoGui.saveFile(this.program, file);
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object object) {
        this.metadata = object;
    }
}

