/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.ssh;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.ssh.SSHClientSetupChainRing;
import com.jcraft.jsch.ConfigRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.OpenSSHConfig;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;

public class SSHConfigFileSetup
implements SSHClientSetupChainRing {
    private final SSHClientSetupChainRing nextChainRing;

    public SSHConfigFileSetup(SSHClientSetupChainRing sSHClientSetupChainRing) {
        this.nextChainRing = sSHClientSetupChainRing;
    }

    @Override
    public Session setup(BoardPort boardPort, JSch jSch) throws JSchException, IOException {
        String string = boardPort.getAddress();
        String string2 = boardPort.getBoardName().contains(".local") ? boardPort.getBoardName() : boardPort.getBoardName() + ".local";
        File file = new File(System.getProperty("user.home"), ".ssh");
        File file2 = new File(file, "config");
        if (!file.exists() || !file2.exists()) {
            if (this.nextChainRing != null) {
                return this.nextChainRing.setup(boardPort, jSch);
            }
            throw new JSchException("Unable to find a way to connect");
        }
        OpenSSHConfig openSSHConfig = OpenSSHConfig.parseFile((String)file2.getAbsolutePath());
        jSch.setConfigRepository((ConfigRepository)new OpenSSHConfigWrapper(openSSHConfig, string));
        return jSch.getSession(string2);
    }

    public static class ConfigWrapper
    implements ConfigRepository.Config {
        private final ConfigRepository.Config config;
        private final String ipAddress;

        public ConfigWrapper(ConfigRepository.Config config, String string) {
            this.config = config;
            this.ipAddress = string;
        }

        public String getHostname() {
            return this.ipAddress;
        }

        public String getUser() {
            String string = this.config.getUser();
            if (string != null) {
                return string;
            }
            return "root";
        }

        public int getPort() {
            return this.config.getPort();
        }

        public String getValue(String string) {
            return this.config.getValue(string);
        }

        public String[] getValues(String string) {
            return this.config.getValues(string);
        }
    }

    public static class OpenSSHConfigWrapper
    implements ConfigRepository {
        private final OpenSSHConfig config;
        private final String ipAddress;

        public OpenSSHConfigWrapper(OpenSSHConfig openSSHConfig, String string) {
            this.config = openSSHConfig;
            this.ipAddress = string;
        }

        public ConfigRepository.Config getConfig(String string) {
            return new ConfigWrapper(this.config.getConfig(string), this.ipAddress);
        }
    }
}

