/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.NetworkDiscovery;
import cc.arduino.packages.discoverers.SerialDiscovery;
import java.util.ArrayList;
import java.util.List;
import processing.app.I18n;

public class DiscoveryManager {
    private final List<Discovery> discoverers = new ArrayList<Discovery>();

    public DiscoveryManager() {
        this.discoverers.add(new SerialDiscovery());
        this.discoverers.add(new NetworkDiscovery());
        for (Discovery discovery : this.discoverers) {
            try {
                discovery.start();
            }
            catch (Exception exception) {
                System.err.println(I18n._("Error starting discovery method: ") + discovery.getClass());
                exception.printStackTrace();
            }
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (Discovery discovery : DiscoveryManager.this.discoverers) {
                    try {
                        discovery.stop();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public List<BoardPort> discovery() {
        ArrayList<BoardPort> arrayList = new ArrayList<BoardPort>();
        for (Discovery discovery : this.discoverers) {
            arrayList.addAll(discovery.discovery());
        }
        return arrayList;
    }

    public BoardPort find(String string) {
        for (BoardPort boardPort : this.discovery()) {
            if (!boardPort.getAddress().equals(string)) continue;
            return boardPort;
        }
        return null;
    }
}

