/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal.ast;

import sun.org.mozilla.javascript.internal.ast.AstNode;
import sun.org.mozilla.javascript.internal.ast.Block;
import sun.org.mozilla.javascript.internal.ast.NodeVisitor;

public class WithStatement
extends AstNode {
    private AstNode expression;
    private AstNode statement;
    private int lp = -1;
    private int rp = -1;

    public WithStatement() {
        this.type = 123;
    }

    public WithStatement(int n) {
        super(n);
        this.type = 123;
    }

    public WithStatement(int n, int n2) {
        super(n, n2);
        this.type = 123;
    }

    public AstNode getExpression() {
        return this.expression;
    }

    public void setExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.expression = astNode;
        astNode.setParent(this);
    }

    public AstNode getStatement() {
        return this.statement;
    }

    public void setStatement(AstNode astNode) {
        this.assertNotNull(astNode);
        this.statement = astNode;
        astNode.setParent(this);
    }

    public int getLp() {
        return this.lp;
    }

    public void setLp(int n) {
        this.lp = n;
    }

    public int getRp() {
        return this.rp;
    }

    public void setRp(int n) {
        this.rp = n;
    }

    public void setParens(int n, int n2) {
        this.lp = n;
        this.rp = n2;
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append("with (");
        stringBuilder.append(this.expression.toSource(0));
        stringBuilder.append(") ");
        stringBuilder.append(this.statement.toSource(n + 1));
        if (!(this.statement instanceof Block)) {
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.expression.visit(nodeVisitor);
            this.statement.visit(nodeVisitor);
        }
    }
}

