/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.util.ResourcesMgr;

public final class PrivateCredentialPermission
extends Permission {
    private static final long serialVersionUID = 5284372143517237068L;
    private static final CredOwner[] EMPTY_PRINCIPALS = new CredOwner[0];
    private String credentialClass;
    private Set principals;
    private transient CredOwner[] credOwners;
    private boolean testing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrivateCredentialPermission(String string, Set<Principal> set) {
        super(string);
        this.credentialClass = string;
        Set<Principal> set2 = set;
        synchronized (set2) {
            if (set.size() == 0) {
                this.credOwners = EMPTY_PRINCIPALS;
            } else {
                this.credOwners = new CredOwner[set.size()];
                int n = 0;
                for (Principal principal : set) {
                    this.credOwners[n++] = new CredOwner(principal.getClass().getName(), principal.getName());
                }
            }
        }
    }

    public PrivateCredentialPermission(String string, String string2) {
        super(string);
        if (!"read".equalsIgnoreCase(string2)) {
            throw new IllegalArgumentException(ResourcesMgr.getString("actions.can.only.be.read."));
        }
        this.init(string);
    }

    public String getCredentialClass() {
        return this.credentialClass;
    }

    public String[][] getPrincipals() {
        if (this.credOwners == null || this.credOwners.length == 0) {
            return new String[0][0];
        }
        String[][] stringArray = new String[this.credOwners.length][2];
        for (int i = 0; i < this.credOwners.length; ++i) {
            stringArray[i][0] = this.credOwners[i].principalClass;
            stringArray[i][1] = this.credOwners[i].principalName;
        }
        return stringArray;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)permission;
        if (!this.impliesCredentialClass(this.credentialClass, privateCredentialPermission.credentialClass)) {
            return false;
        }
        return this.impliesPrincipalSet(this.credOwners, privateCredentialPermission.credOwners);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PrivateCredentialPermission)) {
            return false;
        }
        PrivateCredentialPermission privateCredentialPermission = (PrivateCredentialPermission)object;
        return this.implies(privateCredentialPermission) && privateCredentialPermission.implies(this);
    }

    @Override
    public int hashCode() {
        return this.credentialClass.hashCode();
    }

    @Override
    public String getActions() {
        return "read";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return null;
    }

    private void init(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("invalid empty name");
        }
        ArrayList<CredOwner> arrayList = new ArrayList<CredOwner>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        String string2 = null;
        String string3 = null;
        if (this.testing) {
            System.out.println("whole name = " + string);
        }
        this.credentialClass = stringTokenizer.nextToken();
        if (this.testing) {
            System.out.println("Credential Class = " + this.credentialClass);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
            Object[] objectArray = new Object[]{string};
            throw new IllegalArgumentException(messageFormat.format(objectArray) + ResourcesMgr.getString("Credential.Class.not.followed.by.a.Principal.Class.and.Name"));
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (this.testing) {
                System.out.println("    Principal Class = " + string2);
            }
            if (!stringTokenizer.hasMoreTokens()) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                Object[] objectArray = new Object[]{string};
                throw new IllegalArgumentException(messageFormat.format(objectArray) + ResourcesMgr.getString("Principal.Class.not.followed.by.a.Principal.Name"));
            }
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (!string3.startsWith("\"")) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                Object[] objectArray = new Object[]{string};
                throw new IllegalArgumentException(messageFormat.format(objectArray) + ResourcesMgr.getString("Principal.Name.must.be.surrounded.by.quotes"));
            }
            if (!string3.endsWith("\"")) {
                while (stringTokenizer.hasMoreTokens() && !(string3 = string3 + stringTokenizer.nextToken()).endsWith("\"")) {
                }
                if (!string3.endsWith("\"")) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("permission.name.name.syntax.invalid."));
                    Object[] objectArray = new Object[]{string};
                    throw new IllegalArgumentException(messageFormat.format(objectArray) + ResourcesMgr.getString("Principal.Name.missing.end.quote"));
                }
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + string3 + "'");
            }
            string3 = string3.substring(1, string3.length() - 1);
            if (string2.equals("*") && !string3.equals("*")) {
                throw new IllegalArgumentException(ResourcesMgr.getString("PrivateCredentialPermission.Principal.Class.can.not.be.a.wildcard.value.if.Principal.Name.is.not.a.wildcard.value"));
            }
            if (this.testing) {
                System.out.println("\tprincipalName = '" + string3 + "'");
            }
            arrayList.add(new CredOwner(string2, string3));
        }
        this.credOwners = new CredOwner[arrayList.size()];
        arrayList.toArray(this.credOwners);
    }

    private boolean impliesCredentialClass(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (this.testing) {
            System.out.println("credential class comparison: " + string + "/" + string2);
        }
        if (string.equals("*")) {
            return true;
        }
        return string.equals(string2);
    }

    private boolean impliesPrincipalSet(CredOwner[] credOwnerArray, CredOwner[] credOwnerArray2) {
        if (credOwnerArray == null || credOwnerArray2 == null) {
            return false;
        }
        if (credOwnerArray2.length == 0) {
            return true;
        }
        if (credOwnerArray.length == 0) {
            return false;
        }
        for (int i = 0; i < credOwnerArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < credOwnerArray2.length; ++j) {
                if (!credOwnerArray[i].implies(credOwnerArray2[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getName().indexOf(" ") == -1 && this.getName().indexOf("\"") == -1) {
            this.credentialClass = this.getName();
            this.credOwners = EMPTY_PRINCIPALS;
        } else {
            this.init(this.getName());
        }
    }

    static class CredOwner
    implements Serializable {
        private static final long serialVersionUID = -5607449830436408266L;
        String principalClass;
        String principalName;

        CredOwner(String string, String string2) {
            this.principalClass = string;
            this.principalName = string2;
        }

        public boolean implies(Object object) {
            if (object == null || !(object instanceof CredOwner)) {
                return false;
            }
            CredOwner credOwner = (CredOwner)object;
            return !(!this.principalClass.equals("*") && !this.principalClass.equals(credOwner.principalClass) || !this.principalName.equals("*") && !this.principalName.equals(credOwner.principalName));
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("CredOwner.Principal.Class.class.Principal.Name.name"));
            Object[] objectArray = new Object[]{this.principalClass, this.principalName};
            return messageFormat.format(objectArray);
        }
    }
}

